/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.persist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.scijava.Context;
import org.scijava.InstantiableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.persist.IClassAdapter;
import sc.fiji.persist.IClassRuntimeAdapter;
import sc.fiji.persist.IObjectScijavaAdapterService;
import sc.fiji.persist.RuntimeTypeAdapterFactory;

public class ScijavaGsonHelper {
    protected static final Logger logger = LoggerFactory.getLogger(ScijavaGsonHelper.class);

    public static Gson getGson(Context ctx) {
        return ScijavaGsonHelper.getGson(ctx, false);
    }

    public static Gson getGson(Context ctx, boolean verbose) {
        return ScijavaGsonHelper.getGsonBuilder(ctx, new GsonBuilder(), verbose).create();
    }

    public static GsonBuilder getGsonBuilder(Context ctx, boolean verbose) {
        return ScijavaGsonHelper.getGsonBuilder(ctx, new GsonBuilder().setPrettyPrinting(), verbose);
    }

    public static GsonBuilder getGsonBuilder(Context ctx, GsonBuilder builder, boolean verbose) {
        Consumer<String> log = verbose ? arg_0 -> ((Logger)logger).info(arg_0) : arg_0 -> ((Logger)logger).debug(arg_0);
        HashMap runTimeAdapters = new HashMap();
        ((IObjectScijavaAdapterService)ctx.getService(IObjectScijavaAdapterService.class)).getAdapters(IClassRuntimeAdapter.class).forEach(pi -> {
            try {
                IClassRuntimeAdapter adapter = (IClassRuntimeAdapter)pi.createInstance();
                if (runTimeAdapters.containsKey(adapter.getBaseClass())) {
                    ClassTypesAndSubTypes typesAndSubTypes = (ClassTypesAndSubTypes)runTimeAdapters.get(adapter.getBaseClass());
                    if (typesAndSubTypes.subClasses.contains(adapter.getRunTimeClass())) {
                        throw new RuntimeException("Presence of conflicting adapters for class " + adapter.getRunTimeClass());
                    }
                    ((ClassTypesAndSubTypes)runTimeAdapters.get(adapter.getBaseClass())).subClasses.add(adapter.getRunTimeClass());
                } else {
                    ClassTypesAndSubTypes element = new ClassTypesAndSubTypes(adapter.getBaseClass());
                    element.subClasses.add(adapter.getRunTimeClass());
                    runTimeAdapters.put(adapter.getBaseClass(), element);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        log.accept("IRunTimeClassAdapters : ");
        runTimeAdapters.values().forEach(typesAndSubTypes -> builder.registerTypeAdapterFactory(typesAndSubTypes.getRunTimeAdapterFactory(log)));
        ((IObjectScijavaAdapterService)ctx.getService(IObjectScijavaAdapterService.class)).getAdapters(IClassRuntimeAdapter.class).forEach(pi -> {
            try {
                IClassRuntimeAdapter adapter = (IClassRuntimeAdapter)pi.createInstance();
                if (adapter.useCustomAdapter()) {
                    builder.registerTypeHierarchyAdapter(adapter.getRunTimeClass(), (Object)adapter);
                }
            }
            catch (InstantiableException e) {
                e.printStackTrace();
            }
        });
        log.accept("IClassAdapters : ");
        ((IObjectScijavaAdapterService)ctx.getService(IObjectScijavaAdapterService.class)).getAdapters(IClassAdapter.class).forEach(pi -> {
            try {
                IClassAdapter adapter = (IClassAdapter)pi.createInstance();
                log.accept("\t " + adapter.getAdapterClass());
                builder.registerTypeHierarchyAdapter(adapter.getAdapterClass(), (Object)adapter);
            }
            catch (InstantiableException e) {
                e.printStackTrace();
            }
        });
        return builder.setPrettyPrinting();
    }

    public static class ClassTypesAndSubTypes<T> {
        final Class<T> baseClass;
        final List<Class<? extends T>> subClasses = new ArrayList<Class<? extends T>>();

        public ClassTypesAndSubTypes(Class<T> clazz) {
            this.baseClass = clazz;
        }

        public RuntimeTypeAdapterFactory<T> getRunTimeAdapterFactory(Consumer<String> log) {
            RuntimeTypeAdapterFactory factory = RuntimeTypeAdapterFactory.of(this.baseClass);
            log.accept("\t " + this.baseClass);
            this.subClasses.forEach(subClass -> {
                log.accept("\t \t " + subClass);
                factory.registerSubtype((Class)subClass);
            });
            return factory;
        }
    }
}

