/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.viewers;

import bdv.util.BdvHandle;
import bdv.viewer.TimePointListener;
import bdv.viewer.TransformListener;
import bvv.vistools.BvvHandle;
import java.util.HashMap;
import java.util.Map;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import sc.fiji.bdvpg.viewers.ViewerAdapter;
import sc.fiji.bdvpg.viewers.ViewerOrthoSyncStarter;

public class ViewerTransformSyncStarter
implements Runnable {
    final ViewerAdapter[] handles;
    ViewerAdapter handleInitialReference = null;
    final Map<ViewerAdapter, TransformListener<AffineTransform3D>> handleToTransformListener = new HashMap<ViewerAdapter, TransformListener<AffineTransform3D>>();
    final boolean synchronizeTime;
    final Map<ViewerAdapter, TimePointListener> handleToTimeListener = new HashMap<ViewerAdapter, TimePointListener>();

    public ViewerTransformSyncStarter(BdvHandle[] bdvHandles, boolean synchronizeTime) {
        this.handles = new ViewerAdapter[bdvHandles.length];
        for (int i = 0; i < bdvHandles.length; ++i) {
            this.handles[i] = new ViewerAdapter(bdvHandles[i]);
        }
        this.synchronizeTime = synchronizeTime;
    }

    public ViewerTransformSyncStarter(BvvHandle[] bvvHandles, boolean synchronizeTime) {
        this.handles = new ViewerAdapter[bvvHandles.length];
        for (int i = 0; i < bvvHandles.length; ++i) {
            this.handles[i] = new ViewerAdapter(bvvHandles[i]);
        }
        this.synchronizeTime = synchronizeTime;
    }

    public ViewerTransformSyncStarter(ViewerAdapter[] handles, boolean synchronizeTime) {
        this.handles = handles;
        this.synchronizeTime = synchronizeTime;
    }

    public void setHandleInitialReference(ViewerAdapter handle) {
        this.handleInitialReference = handle;
    }

    @Override
    public void run() {
        AffineTransform3D at3Dorigin = this.getViewTransformForInitialSynchronization();
        for (int i = 0; i < this.handles.length; ++i) {
            ViewerAdapter currentHandle = this.handles[i];
            ViewerAdapter nextHandle = i == this.handles.length - 1 ? this.handles[0] : this.handles[i + 1];
            TransformListener<AffineTransform3D> listener = at3D -> this.propagateTransformIfNecessary((AffineTransform3D)at3D, currentHandle, nextHandle);
            currentHandle.addTransformListener(listener);
            this.handleToTransformListener.put(this.handles[i], listener);
            if (!this.synchronizeTime) continue;
            TimePointListener timeListener = timepoint -> {
                if (nextHandle.state().getCurrentTimepoint() != timepoint) {
                    nextHandle.setTimepoint(timepoint);
                }
            };
            currentHandle.addTimePointListener(timeListener);
            this.handleToTimeListener.put(this.handles[i], timeListener);
        }
        if (this.handleInitialReference != null && at3Dorigin != null) {
            for (ViewerAdapter handle : this.handles) {
                handle.state().setViewerTransform(at3Dorigin.copy());
                handle.requestRepaint();
                if (!this.synchronizeTime) continue;
                handle.state().setCurrentTimepoint(this.handleInitialReference.state().getCurrentTimepoint());
            }
        }
    }

    void propagateTransformIfNecessary(AffineTransform3D at3D, ViewerAdapter currentHandle, ViewerAdapter nextHandle) {
        double cur_wcx = currentHandle.getWidth() / 2.0;
        double cur_wcy = currentHandle.getHeight() / 2.0;
        RealPoint centerScreenCurrentBdv = new RealPoint(new double[]{cur_wcx, cur_wcy, 0.0});
        RealPoint centerScreenGlobalCoord = new RealPoint(3);
        at3D.inverse().apply((RealLocalizable)centerScreenCurrentBdv, (RealPositionable)centerScreenGlobalCoord);
        AffineTransform3D nextAffineTransform = new AffineTransform3D();
        nextAffineTransform.set(at3D);
        nextAffineTransform.set(0.0, 0, 3);
        nextAffineTransform.set(0.0, 1, 3);
        nextAffineTransform.set(0.0, 2, 3);
        double next_wcx = nextHandle.getWidth() / 2.0;
        double next_wcy = nextHandle.getHeight() / 2.0;
        RealPoint centerScreenNextBdv = new RealPoint(new double[]{next_wcx, next_wcy, 0.0});
        RealPoint shiftNextBdv = new RealPoint(3);
        nextAffineTransform.inverse().apply((RealLocalizable)centerScreenNextBdv, (RealPositionable)shiftNextBdv);
        double sx = -centerScreenGlobalCoord.getDoublePosition(0) + shiftNextBdv.getDoublePosition(0);
        double sy = -centerScreenGlobalCoord.getDoublePosition(1) + shiftNextBdv.getDoublePosition(1);
        double sz = -centerScreenGlobalCoord.getDoublePosition(2) + shiftNextBdv.getDoublePosition(2);
        RealPoint shiftWindow = new RealPoint(new double[]{sx, sy, sz});
        RealPoint shiftMatrix = new RealPoint(3);
        nextAffineTransform.apply((RealLocalizable)shiftWindow, (RealPositionable)shiftMatrix);
        nextAffineTransform.set(shiftMatrix.getDoublePosition(0), 0, 3);
        nextAffineTransform.set(shiftMatrix.getDoublePosition(1), 1, 3);
        nextAffineTransform.set(shiftMatrix.getDoublePosition(2), 2, 3);
        AffineTransform3D ati = new AffineTransform3D();
        nextHandle.state().getViewerTransform(ati);
        if (!ViewerOrthoSyncStarter.MatrixApproxEquals(nextAffineTransform.getRowPackedCopy(), ati.getRowPackedCopy())) {
            AffineTransform3D nextAt3D = nextAffineTransform.copy();
            nextAt3D.set(nextAffineTransform.getRowPackedCopy());
            nextHandle.state().setViewerTransform(nextAt3D);
            nextHandle.requestRepaint();
        }
    }

    private AffineTransform3D getViewTransformForInitialSynchronization() {
        AffineTransform3D at3Dorigin = null;
        for (ViewerAdapter handle : this.handles) {
            if (!handle.equals(this.handleInitialReference)) continue;
            at3Dorigin = new AffineTransform3D();
            handle.state().getViewerTransform(at3Dorigin);
        }
        return at3Dorigin;
    }

    public Map<ViewerAdapter, TransformListener<AffineTransform3D>> getSynchronizers() {
        return this.handleToTransformListener;
    }

    public boolean isSynchronizingTime() {
        return this.synchronizeTime;
    }

    public Map<ViewerAdapter, TimePointListener> getTimeSynchronizers() {
        return this.handleToTimeListener;
    }
}

