/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.viewers;

import bdv.util.PlaceHolderSource;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerStateChange;
import bdv.viewer.ViewerStateChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.viewers.ViewerAdapter;

public class ViewerStateSyncStarter
implements Runnable {
    final ViewerAdapter[] handles;
    final Map<ViewerAdapter, ViewerStateChangeListener> handleToStateListener = new HashMap<ViewerAdapter, ViewerStateChangeListener>();
    final AtomicBoolean isPropagating = new AtomicBoolean();
    ViewerAdapter currentPropagating = null;

    public ViewerStateSyncStarter(ViewerAdapter ... handles) {
        this.handles = handles;
    }

    @Override
    public void run() {
        this.isPropagating.set(false);
        for (ViewerAdapter handle : this.handles) {
            BasicStateListener stateListener = new BasicStateListener(handle, this.isPropagating);
            handle.state().changeListeners().add((Object)stateListener);
            this.handleToStateListener.put(handle, stateListener);
        }
    }

    public Map<ViewerAdapter, ViewerStateChangeListener> getSynchronizers() {
        return this.handleToStateListener;
    }

    void updateState(ViewerAdapter adapter) {
        this.isPropagating.set(true);
        this.currentPropagating = adapter;
        for (ViewerAdapter adapterTest : this.handles) {
            if (adapter.equals(adapterTest)) continue;
            HashSet stateToCopy = new HashSet(adapter.state().getSources());
            HashSet stateToAdapt = new HashSet(adapterTest.state().getSources());
            stateToAdapt.removeIf(source -> source.getSpimSource() instanceof PlaceHolderSource);
            stateToCopy.removeIf(source -> source.getSpimSource() instanceof PlaceHolderSource);
            stateToCopy.removeAll(stateToAdapt);
            if (stateToCopy.size() != 0) {
                if (adapterTest.bvvPanel != null) {
                    for (SourceAndConverter<?> sourceAndConverter : stateToCopy) {
                        adapterTest.bvvPanel.getConverterSetups().put(sourceAndConverter, SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(sourceAndConverter));
                    }
                } else {
                    SourceAndConverterServices.getBdvDisplayService().getDisplays().forEach(bdvh -> {
                        for (SourceAndConverter source : stateToCopy) {
                            bdvh.getConverterSetups().put(source, SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(source));
                        }
                    });
                }
                adapterTest.state().addSources(stateToCopy);
                for (SourceAndConverter<?> sourceAndConverter : stateToCopy) {
                    adapterTest.state().setSourceActive(sourceAndConverter, true);
                }
            }
            stateToAdapt.removeAll(new HashSet(adapter.state().getSources()));
            if (stateToAdapt.size() == 0) continue;
            adapterTest.state().removeSources(stateToAdapt);
        }
        this.currentPropagating = null;
        this.isPropagating.set(false);
    }

    class BasicStateListener
    implements ViewerStateChangeListener {
        final ViewerAdapter current;
        final AtomicBoolean isPropagating;

        BasicStateListener(ViewerAdapter current, AtomicBoolean isPropagating) {
            this.current = current;
            this.isPropagating = isPropagating;
        }

        @Override
        public void viewerStateChanged(ViewerStateChange change) {
            switch (change) {
                case NUM_SOURCES_CHANGED: {
                    if (this.isPropagating.get() && ViewerStateSyncStarter.this.currentPropagating != this.current) break;
                    ViewerStateSyncStarter.this.updateState(this.current);
                }
            }
        }
    }
}

