/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.viewers;

import bdv.viewer.TimePointListener;
import bdv.viewer.TransformListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import sc.fiji.bdvpg.viewers.ViewerAdapter;

public class ViewerOrthoSyncStarter
implements Runnable {
    final ViewerAdapter[] handles = new ViewerAdapter[3];
    ViewerAdapter handleInitialReference = null;
    final Map<ViewerAdapter, TransformListener<AffineTransform3D>> handleToTransformListener = new HashMap<ViewerAdapter, TransformListener<AffineTransform3D>>();
    final boolean synchronizeTime;
    final Map<ViewerAdapter, TimePointListener> handleToTimeListener = new HashMap<ViewerAdapter, TimePointListener>();

    public ViewerOrthoSyncStarter(ViewerAdapter handleX, ViewerAdapter handleY, ViewerAdapter handleZ, boolean syncTime) {
        this.handles[0] = handleX;
        this.handles[1] = handleY;
        this.handles[2] = handleZ;
        this.synchronizeTime = syncTime;
    }

    public void setHandleInitialReference(ViewerAdapter handle) {
        this.handleInitialReference = handle;
    }

    @Override
    public void run() {
        AffineTransform3D at3Dorigin = this.getViewTransformForInitialSynchronization();
        TransformListener<AffineTransform3D> listener = at3D -> this.propagateTransformIfNecessary((AffineTransform3D)at3D, this.handles[0], this.handles[1], this::getRotatedView0);
        this.handles[0].addTransformListener(listener);
        this.handleToTransformListener.put(this.handles[0], listener);
        listener = at3D -> this.propagateTransformIfNecessary((AffineTransform3D)at3D, this.handles[1], this.handles[2], this::getRotatedView1);
        this.handles[1].addTransformListener(listener);
        this.handleToTransformListener.put(this.handles[1], listener);
        listener = at3D -> this.propagateTransformIfNecessary((AffineTransform3D)at3D, this.handles[2], this.handles[0], this::getRotatedView2);
        this.handles[2].addTransformListener(listener);
        this.handleToTransformListener.put(this.handles[2], listener);
        if (this.synchronizeTime) {
            TimePointListener timeListener = timepoint -> {
                if (this.handles[1].state().getCurrentTimepoint() != timepoint) {
                    this.handles[1].setTimepoint(timepoint);
                }
            };
            this.handles[0].addTimePointListener(timeListener);
            this.handleToTimeListener.put(this.handles[0], timeListener);
            timeListener = timepoint -> {
                if (this.handles[2].state().getCurrentTimepoint() != timepoint) {
                    this.handles[2].setTimepoint(timepoint);
                }
            };
            this.handles[1].addTimePointListener(timeListener);
            this.handleToTimeListener.put(this.handles[1], timeListener);
            timeListener = timepoint -> {
                if (this.handles[0].state().getCurrentTimepoint() != timepoint) {
                    this.handles[0].setTimepoint(timepoint);
                }
            };
            this.handles[2].addTimePointListener(timeListener);
            this.handleToTimeListener.put(this.handles[2], timeListener);
        }
        if (this.handleInitialReference != null && at3Dorigin != null) {
            for (ViewerAdapter handle : this.handles) {
                handle.state().setViewerTransform(at3Dorigin.copy());
                handle.requestRepaint();
                if (!this.synchronizeTime) continue;
                handle.state().setCurrentTimepoint(handle.state().getCurrentTimepoint());
            }
        }
    }

    void propagateTransformIfNecessary(AffineTransform3D at3D, ViewerAdapter currentHandle, ViewerAdapter nextHandle, Function<double[], double[]> rotator) {
        double cur_wcx = currentHandle.getWidth() / 2.0;
        double cur_wcy = currentHandle.getHeight() / 2.0;
        RealPoint centerScreenCurrentBvv = new RealPoint(new double[]{cur_wcx, cur_wcy, 0.0});
        RealPoint centerScreenGlobalCoord = new RealPoint(3);
        at3D.inverse().apply((RealLocalizable)centerScreenCurrentBvv, (RealPositionable)centerScreenGlobalCoord);
        AffineTransform3D nextAffineTransform = new AffineTransform3D();
        nextAffineTransform.set(at3D);
        nextAffineTransform.set(0.0, 0, 3);
        nextAffineTransform.set(0.0, 1, 3);
        nextAffineTransform.set(0.0, 2, 3);
        nextAffineTransform.set(rotator.apply(nextAffineTransform.getRowPackedCopy()));
        double next_wcx = nextHandle.getWidth() / 2.0;
        double next_wcy = nextHandle.getHeight() / 2.0;
        RealPoint centerScreenNextBvv = new RealPoint(new double[]{next_wcx, next_wcy, 0.0});
        RealPoint shiftNextBvv = new RealPoint(3);
        nextAffineTransform.inverse().apply((RealLocalizable)centerScreenNextBvv, (RealPositionable)shiftNextBvv);
        double sx = -centerScreenGlobalCoord.getDoublePosition(0) + shiftNextBvv.getDoublePosition(0);
        double sy = -centerScreenGlobalCoord.getDoublePosition(1) + shiftNextBvv.getDoublePosition(1);
        double sz = -centerScreenGlobalCoord.getDoublePosition(2) + shiftNextBvv.getDoublePosition(2);
        RealPoint shiftWindow = new RealPoint(new double[]{sx, sy, sz});
        RealPoint shiftMatrix = new RealPoint(3);
        nextAffineTransform.apply((RealLocalizable)shiftWindow, (RealPositionable)shiftMatrix);
        nextAffineTransform.set(shiftMatrix.getDoublePosition(0), 0, 3);
        nextAffineTransform.set(shiftMatrix.getDoublePosition(1), 1, 3);
        nextAffineTransform.set(shiftMatrix.getDoublePosition(2), 2, 3);
        AffineTransform3D ati = new AffineTransform3D();
        nextHandle.state().getViewerTransform(ati);
        if (!ViewerOrthoSyncStarter.MatrixApproxEquals(nextAffineTransform.getRowPackedCopy(), ati.getRowPackedCopy())) {
            AffineTransform3D nextAt3D = nextAffineTransform.copy();
            nextAt3D.set(nextAffineTransform.getRowPackedCopy());
            nextHandle.state().setViewerTransform(nextAt3D);
            nextHandle.requestRepaint();
        }
    }

    public double[] getRotatedView0(double[] m) {
        return new double[]{m[0], m[1], m[2], m[3], -m[8], -m[9], -m[10], m[7], m[4], m[5], m[6], m[11]};
    }

    public double[] getRotatedView1(double[] m) {
        return new double[]{m[4], m[5], m[6], m[3], m[8], m[9], m[10], m[7], m[0], m[1], m[2], m[11]};
    }

    public double[] getRotatedView2(double[] m) {
        return new double[]{m[8], m[9], m[10], m[3], m[4], m[5], m[6], m[7], -m[0], -m[1], -m[2], m[11]};
    }

    private AffineTransform3D getViewTransformForInitialSynchronization() {
        AffineTransform3D at3Dorigin = null;
        for (ViewerAdapter handle : this.handles) {
            if (!handle.equals(this.handleInitialReference)) continue;
            at3Dorigin = new AffineTransform3D();
            handle.state().getViewerTransform(at3Dorigin);
        }
        return at3Dorigin;
    }

    public Map<ViewerAdapter, TransformListener<AffineTransform3D>> getSynchronizers() {
        return this.handleToTransformListener;
    }

    public boolean isSynchronizingTime() {
        return this.synchronizeTime;
    }

    public Map<ViewerAdapter, TimePointListener> getTimeSynchronizers() {
        return this.handleToTimeListener;
    }

    public static boolean MatrixApproxEquals(double[] m1, double[] m2) {
        assert (m1.length == m2.length);
        boolean ans = true;
        for (int i = 0; i < m1.length; ++i) {
            if (!(Math.abs(m1[i] - m2[i]) > 1000000.0 * Math.ulp(Math.min(Math.abs(m1[i]), Math.abs(m2[i]))))) continue;
            ans = false;
            break;
        }
        return ans;
    }
}

