/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.viewers;

import bdv.util.BdvHandle;
import bdv.viewer.TimePointListener;
import bdv.viewer.TransformListener;
import bdv.viewer.ViewerPanel;
import bdv.viewer.ViewerState;
import bvv.core.VolumeViewerPanel;
import bvv.vistools.BvvHandle;
import net.imglib2.realtransform.AffineTransform3D;

public class ViewerAdapter {
    final VolumeViewerPanel bvvPanel;
    final ViewerPanel bdvPanel;

    public ViewerAdapter(ViewerPanel viewerPanel) {
        this.bvvPanel = null;
        this.bdvPanel = viewerPanel;
    }

    public ViewerAdapter(VolumeViewerPanel viewerPanel) {
        this.bvvPanel = viewerPanel;
        this.bdvPanel = null;
    }

    public ViewerAdapter(BdvHandle bdv) {
        this.bvvPanel = null;
        this.bdvPanel = bdv.getViewerPanel();
    }

    public ViewerAdapter(BvvHandle bvv) {
        this.bvvPanel = bvv.getViewerPanel();
        this.bdvPanel = null;
    }

    public double getWidth() {
        if (this.bdvPanel != null) {
            return this.bdvPanel.getWidth();
        }
        return this.bvvPanel.getWidth();
    }

    public double getHeight() {
        if (this.bdvPanel != null) {
            return this.bdvPanel.getHeight();
        }
        return this.bvvPanel.getHeight();
    }

    public ViewerState state() {
        if (this.bdvPanel != null) {
            return this.bdvPanel.state();
        }
        return this.bvvPanel.state();
    }

    public void requestRepaint() {
        if (this.bdvPanel != null) {
            this.bdvPanel.requestRepaint();
        } else {
            this.bvvPanel.requestRepaint();
        }
    }

    public void addTransformListener(TransformListener<AffineTransform3D> listener) {
        if (this.bdvPanel != null) {
            this.bdvPanel.transformListeners().add(listener);
        } else {
            this.bvvPanel.transformListeners().add(listener);
        }
    }

    public void setTimepoint(int timepoint) {
        if (this.bdvPanel != null) {
            this.bdvPanel.setTimepoint(timepoint);
        } else {
            this.bvvPanel.setTimepoint(timepoint);
        }
    }

    public void addTimePointListener(TimePointListener timeListener) {
        if (this.bdvPanel != null) {
            this.bdvPanel.timePointListeners().add((Object)timeListener);
        } else {
            this.bvvPanel.addTimePointListener(timeListener);
        }
    }

    public void removeTransformListener(TransformListener<AffineTransform3D> listener) {
        if (this.bdvPanel != null) {
            this.bdvPanel.transformListeners().remove(listener);
        } else {
            this.bvvPanel.transformListeners().remove(listener);
        }
    }

    public void removeTimePointListener(TimePointListener listener) {
        if (this.bdvPanel != null) {
            this.bdvPanel.timePointListeners().remove((Object)listener);
        } else {
            this.bvvPanel.removeTimePointListener(listener);
        }
    }

    public int hashCode() {
        if (this.bdvPanel != null) {
            return this.bdvPanel.hashCode();
        }
        return this.bvvPanel.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewerAdapter)) {
            return false;
        }
        ViewerAdapter c = (ViewerAdapter)o;
        if (c.bdvPanel != null) {
            return c.bdvPanel.equals(this.bdvPanel);
        }
        return c.bvvPanel.equals(this.bvvPanel);
    }
}

