/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.spimdata.importer;

import java.io.File;
import java.nio.file.Paths;
import java.util.function.Function;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.XmlIoSpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class SpimDataFromXmlImporter
implements Runnable,
Function<String, AbstractSpimData<?>> {
    protected static final Logger logger = LoggerFactory.getLogger(SpimDataFromXmlImporter.class);
    final String dataLocation;

    public SpimDataFromXmlImporter(File file) {
        this.dataLocation = file.getAbsolutePath();
    }

    public SpimDataFromXmlImporter(String dataLocation) {
        this.dataLocation = dataLocation;
    }

    @Override
    public void run() {
        this.apply(this.dataLocation);
    }

    public AbstractSpimData<?> get() {
        return this.apply(this.dataLocation);
    }

    @Override
    public AbstractSpimData<?> apply(String dataLocation) {
        AbstractSpimData sd = null;
        try {
            sd = new XmlIoSpimData().load(dataLocation);
            SourceAndConverterServices.getSourceAndConverterService().register(sd);
            SourceAndConverterServices.getSourceAndConverterService().setSpimDataName(sd, Paths.get(dataLocation, new String[0]).getFileName().toString());
            SourceAndConverterServices.getSourceAndConverterService().setMetadata(sd, "SPIM_DATA_LOCATION", (Object)dataLocation);
        }
        catch (SpimDataException e) {
            e.printStackTrace();
        }
        return sd;
    }
}

