/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.spimdata.exporter;

import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import bdv.viewer.SourceAndConverter;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.HashMap;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.XmlIoSpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import org.scijava.Context;
import org.scijava.InstantiableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.spimdata.EntityHandler;
import sc.fiji.bdvpg.spimdata.IEntityHandlerService;

public class XmlFromSpimDataExporter
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(XmlFromSpimDataExporter.class);
    final AbstractSpimData<?> spimData;
    final String dataLocation;
    final Context context;

    public static boolean isPathValid(String path) {
        try {
            Paths.get(path, new String[0]);
        }
        catch (InvalidPathException ex) {
            return false;
        }
        return true;
    }

    public XmlFromSpimDataExporter(AbstractSpimData<?> spimData, String dataLocation, Context ctx) {
        this.spimData = spimData;
        if (XmlFromSpimDataExporter.isPathValid(dataLocation)) {
            spimData.setBasePath(new File(dataLocation));
        } else {
            logger.error("Trying to save spimdata into an invalid file Path : " + dataLocation);
        }
        this.dataLocation = dataLocation;
        this.context = ctx;
    }

    @Override
    public void run() {
        try {
            if (this.context != null) {
                HashMap entityClassToHandler = new HashMap();
                IEntityHandlerService entityHandlerService = (IEntityHandlerService)this.context.getService(IEntityHandlerService.class);
                HashMap idToSac = new HashMap();
                SourceAndConverterService sac_service = (SourceAndConverterService)this.context.getService(SourceAndConverterService.class);
                sac_service.getSourceAndConverterFromSpimdata(this.spimData).forEach(sac -> {
                    SourceAndConverterService.SpimDataInfo sdi = (SourceAndConverterService.SpimDataInfo)sac_service.getMetadata((SourceAndConverter<?>)sac, "SPIMDATA");
                    idToSac.put(sdi.setupId, sac);
                });
                entityHandlerService.getHandlers(EntityHandler.class).forEach(pi -> {
                    try {
                        EntityHandler handler = (EntityHandler)pi.createInstance();
                        entityClassToHandler.put(handler.getEntityType(), handler);
                    }
                    catch (InstantiableException e) {
                        e.printStackTrace();
                    }
                });
                AbstractSequenceDescription seq = this.spimData.getSequenceDescription();
                for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
                    entityClassToHandler.keySet().forEach(entityClass -> {
                        Entity e = setup.getAttribute(entityClass);
                        if (e != null) {
                            if (idToSac.containsKey(setup)) {
                                SourceAndConverter sac = (SourceAndConverter)idToSac.get(setup);
                                ((EntityHandler)entityClassToHandler.get(entityClass)).writeEntity(setup, sac);
                            } else {
                                logger.warn("No source found for setup " + setup);
                            }
                        }
                    });
                }
            }
            SourceAndConverterServices.getSourceAndConverterService().setSpimDataName(this.spimData, this.dataLocation);
            SourceAndConverterServices.getSourceAndConverterService().setMetadata(this.spimData, "SPIM_DATA_LOCATION", (Object)this.dataLocation);
            if (this.spimData instanceof SpimData) {
                new XmlIoSpimData().save((AbstractSpimData)((SpimData)this.spimData), this.dataLocation);
            } else if (this.spimData instanceof SpimDataMinimal) {
                new XmlIoSpimDataMinimal().save((SpimDataMinimal)this.spimData, this.dataLocation);
            } else {
                logger.error("Cannot save SpimData of class : " + this.spimData.getClass().getSimpleName());
            }
        }
        catch (SpimDataException e) {
            e.printStackTrace();
        }
    }
}

