/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.sourceandconverter.transform;

import bdv.AbstractSpimSource;
import bdv.tools.transformation.TransformedSource;
import bdv.viewer.SourceAndConverter;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewTransform;
import mpicbg.spim.data.registration.ViewTransformAffine;
import net.imglib2.realtransform.AffineTransform3D;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterAndTimeRange;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceAffineTransformer;

public class SourceTransformHelper {
    public static <T> SourceAndConverter<T> mutate(AffineTransform3D affineTransform3D, SourceAndConverterAndTimeRange<T> sacTR) {
        if (sacTR.sac.getSpimSource() instanceof AbstractSpimSource) {
            if (SourceAndConverterServices.getSourceAndConverterService().getMetadata(sacTR.sac, "SPIMDATA") != null) {
                return SourceTransformHelper.mutateLastSpimdataTransformation(affineTransform3D, sacTR);
            }
            if (sacTR.sac.getSpimSource() instanceof TransformedSource) {
                return SourceTransformHelper.mutateTransformedSourceAndConverter(affineTransform3D, sacTR);
            }
            return SourceTransformHelper.createNewTransformedSourceAndConverter(affineTransform3D, sacTR);
        }
        if (sacTR.sac.getSpimSource() instanceof TransformedSource) {
            return SourceTransformHelper.mutateTransformedSourceAndConverter(affineTransform3D, sacTR);
        }
        return SourceTransformHelper.createNewTransformedSourceAndConverter(affineTransform3D, sacTR);
    }

    public static <T> SourceAndConverter<T> append(AffineTransform3D affineTransform3D, SourceAndConverterAndTimeRange<T> sacTR) {
        if (sacTR.sac.getSpimSource() instanceof AbstractSpimSource) {
            if (SourceAndConverterServices.getSourceAndConverterService().getMetadata(sacTR.sac, "SPIMDATA") != null) {
                return SourceTransformHelper.appendNewSpimdataTransformation(affineTransform3D, sacTR);
            }
            return SourceTransformHelper.createNewTransformedSourceAndConverter(affineTransform3D, sacTR);
        }
        System.err.println("Cannot append a transformation to a source of class : " + sacTR.sac.getSpimSource().getClass().getSimpleName());
        System.err.println("You can try 'mutate' or wrap as transformed Source");
        return SourceTransformHelper.createNewTransformedSourceAndConverter(affineTransform3D, sacTR);
    }

    public static <T> SourceAndConverter<T> set(AffineTransform3D affineTransform3D, SourceAndConverterAndTimeRange<T> sacTR) {
        if (sacTR.sac.getSpimSource() instanceof AbstractSpimSource) {
            if (SourceAndConverterServices.getSourceAndConverterService().getMetadata(sacTR.sac, "SPIMDATA") != null) {
                return SourceTransformHelper.setLastSpimdataTransformation(affineTransform3D, sacTR);
            }
            if (sacTR.sac.getSpimSource() instanceof TransformedSource) {
                return SourceTransformHelper.setTransformedSourceAndConverter(affineTransform3D, sacTR);
            }
            return SourceTransformHelper.createNewTransformedSourceAndConverter(affineTransform3D, sacTR);
        }
        if (sacTR.sac.getSpimSource() instanceof TransformedSource) {
            return SourceTransformHelper.setTransformedSourceAndConverter(affineTransform3D, sacTR);
        }
        return SourceTransformHelper.createNewTransformedSourceAndConverter(affineTransform3D, sacTR);
    }

    public static <T> SourceAndConverter<T> cancel(AffineTransform3D affineTransform3D, SourceAndConverterAndTimeRange<T> sacTR) {
        return sacTR.sac;
    }

    public static <T> SourceAndConverter<T> log(AffineTransform3D affineTransform3D, SourceAndConverterAndTimeRange<T> sacTR, Consumer<String> logger) {
        logger.accept(affineTransform3D.toString());
        return sacTR.sac;
    }

    public static <T> SourceAndConverter<T> mutateLastSpimdataTransformation(AffineTransform3D affineTransform3D, SourceAndConverterAndTimeRange<T> sacTR) {
        assert (SourceAndConverterServices.getSourceAndConverterService().containsMetadata(sacTR.sac, "SPIMDATA"));
        assert (SourceAndConverterServices.getSourceAndConverterService().getMetadata(sacTR.sac, "SPIMDATA") instanceof SourceAndConverterService.SpimDataInfo);
        SourceAndConverterService.SpimDataInfo sdi = (SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata(sacTR.sac, "SPIMDATA");
        sacTR.getTimePoints().forEach(timePoint -> {
            ViewRegistration vr = sdi.asd.getViewRegistrations().getViewRegistration(timePoint, sdi.setupId);
            ViewTransform vt = (ViewTransform)vr.getTransformList().get(0);
            AffineTransform3D at3D = new AffineTransform3D();
            at3D.concatenate(vt.asAffine3D());
            at3D.preConcatenate(affineTransform3D);
            ViewTransformAffine newvt = new ViewTransformAffine(vt.getName(), at3D);
            vr.getTransformList().remove(0);
            vr.getTransformList().add(0, newvt);
            vr.updateModel();
            try {
                Method updateBdvSource = Class.forName("bdv.AbstractSpimSource").getDeclaredMethod("loadTimepoint", Integer.TYPE);
                updateBdvSource.setAccessible(true);
                AbstractSpimSource ass = (AbstractSpimSource)sacTR.sac.getSpimSource();
                updateBdvSource.invoke((Object)ass, timePoint);
                if (sacTR.sac.asVolatile() != null) {
                    ass = (AbstractSpimSource)sacTR.sac.asVolatile().getSpimSource();
                    updateBdvSource.invoke((Object)ass, timePoint);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return sacTR.sac;
    }

    public static <T> SourceAndConverter<T> setLastSpimdataTransformation(AffineTransform3D affineTransform3D, SourceAndConverterAndTimeRange<T> sacTR) {
        assert (SourceAndConverterServices.getSourceAndConverterService().containsMetadata(sacTR.sac, "SPIMDATA"));
        assert (SourceAndConverterServices.getSourceAndConverterService().getMetadata(sacTR.sac, "SPIMDATA") instanceof SourceAndConverterService.SpimDataInfo);
        SourceAndConverterService.SpimDataInfo sdi = (SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata(sacTR.sac, "SPIMDATA");
        sacTR.getTimePoints().forEach(timePoint -> {
            ViewRegistration vr = sdi.asd.getViewRegistrations().getViewRegistration(timePoint, sdi.setupId);
            ViewTransform vt = (ViewTransform)vr.getTransformList().get(vr.getTransformList().size() - 1);
            ViewTransformAffine newvt = new ViewTransformAffine(vt.getName(), affineTransform3D);
            vr.getTransformList().remove(vt);
            vr.getTransformList().add(newvt);
            vr.updateModel();
            try {
                Method updateBdvSource = Class.forName("bdv.AbstractSpimSource").getDeclaredMethod("loadTimepoint", Integer.TYPE);
                updateBdvSource.setAccessible(true);
                AbstractSpimSource ass = (AbstractSpimSource)sacTR.sac.getSpimSource();
                updateBdvSource.invoke((Object)ass, timePoint);
                if (sacTR.sac.asVolatile() != null) {
                    ass = (AbstractSpimSource)sacTR.sac.asVolatile().getSpimSource();
                    updateBdvSource.invoke((Object)ass, timePoint);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return sacTR.sac;
    }

    public static <T> SourceAndConverter<T> appendNewSpimdataTransformation(AffineTransform3D affineTransform3D, SourceAndConverterAndTimeRange<T> sacTR) {
        assert (SourceAndConverterServices.getSourceAndConverterService().containsMetadata(sacTR.sac, "SPIMDATA"));
        assert (SourceAndConverterServices.getSourceAndConverterService().getMetadata(sacTR.sac, "SPIMDATA") instanceof SourceAndConverterService.SpimDataInfo);
        SourceAndConverterService.SpimDataInfo sdi = (SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata(sacTR.sac, "SPIMDATA");
        ViewTransformAffine newvt = new ViewTransformAffine("Manual transform", affineTransform3D);
        sacTR.getTimePoints().forEach(arg_0 -> SourceTransformHelper.lambda$appendNewSpimdataTransformation$2(sdi, (ViewTransform)newvt, sacTR, arg_0));
        return sacTR.sac;
    }

    public static <T> SourceAndConverter<T> createNewTransformedSourceAndConverter(AffineTransform3D affineTransform3D, SourceAndConverterAndTimeRange<T> sacTR) {
        return new SourceAffineTransformer(sacTR.sac, affineTransform3D).get();
    }

    public static <T> SourceAndConverter<T> mutateTransformedSourceAndConverter(AffineTransform3D affineTransform3D, SourceAndConverterAndTimeRange<T> sacTR) {
        assert (sacTR.sac.getSpimSource() instanceof TransformedSource);
        AffineTransform3D at3D = new AffineTransform3D();
        ((TransformedSource)sacTR.sac.getSpimSource()).getFixedTransform(at3D);
        ((TransformedSource)sacTR.sac.getSpimSource()).setFixedTransform(at3D.preConcatenate(affineTransform3D));
        return sacTR.sac;
    }

    public static <T> SourceAndConverter<T> setTransformedSourceAndConverter(AffineTransform3D affineTransform3D, SourceAndConverterAndTimeRange<T> sacTR) {
        assert (sacTR.sac.getSpimSource() instanceof TransformedSource);
        ((TransformedSource)sacTR.sac.getSpimSource()).setFixedTransform(affineTransform3D);
        return sacTR.sac;
    }

    private static /* synthetic */ void lambda$appendNewSpimdataTransformation$2(SourceAndConverterService.SpimDataInfo sdi, ViewTransform newvt, SourceAndConverterAndTimeRange sacTR, int timePoint) {
        sdi.asd.getViewRegistrations().getViewRegistration(timePoint, sdi.setupId).preconcatenateTransform(newvt);
        sdi.asd.getViewRegistrations().getViewRegistration(timePoint, sdi.setupId).updateModel();
        try {
            Method updateBdvSource = Class.forName("bdv.AbstractSpimSource").getDeclaredMethod("loadTimepoint", Integer.TYPE);
            updateBdvSource.setAccessible(true);
            AbstractSpimSource ass = (AbstractSpimSource)sacTR.sac.getSpimSource();
            updateBdvSource.invoke((Object)ass, timePoint);
            if (sacTR.sac.asVolatile() != null) {
                ass = (AbstractSpimSource)sacTR.sac.asVolatile().getSpimSource();
                updateBdvSource.invoke((Object)ass, timePoint);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

