/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.sourceandconverter.transform;

import bdv.cache.SharedQueue;
import bdv.util.ResampledSource;
import bdv.util.VolatileSource;
import bdv.util.volatiles.VolatileTypeMatcher;
import bdv.viewer.SourceAndConverter;
import java.util.function.Function;
import net.imglib2.Volatile;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class SourceResampler<T extends NumericType<T> & NativeType<T>>
implements Runnable,
Function<SourceAndConverter<T>, SourceAndConverter<T>> {
    final SourceAndConverter<T> sac_in;
    final SourceAndConverter<?> model;
    final boolean reuseMipMaps;
    final boolean interpolate;
    final boolean cache;
    final int defaultMipMapLevel;
    private final String name;

    public SourceResampler(SourceAndConverter<T> sac_in, SourceAndConverter<?> model, String name, boolean reuseMipmaps, boolean cache, boolean interpolate, int defaultMipMapLevel) {
        this.name = name;
        this.reuseMipMaps = reuseMipmaps;
        this.model = model;
        this.sac_in = sac_in;
        this.interpolate = interpolate;
        this.cache = cache;
        this.defaultMipMapLevel = defaultMipMapLevel;
    }

    @Override
    public void run() {
    }

    public SourceAndConverter<T> get() {
        return this.apply(this.sac_in);
    }

    @Override
    public SourceAndConverter<T> apply(SourceAndConverter<T> src) {
        SourceAndConverter<T> sac;
        ResampledSource srcRsampled = new ResampledSource(src.getSpimSource(), this.model.getSpimSource(), this.name, this.reuseMipMaps, this.cache, this.interpolate, this.defaultMipMapLevel);
        if (src.asVolatile() != null) {
            Object vsrcResampled = this.cache ? new VolatileSource(srcRsampled, () -> VolatileTypeMatcher.getVolatileTypeForType((NativeType)((NativeType)srcRsampled.getType())), new SharedQueue(Math.max(Runtime.getRuntime().availableProcessors() - 1, 1))) : new ResampledSource<Volatile<T>>(src.asVolatile().getSpimSource(), this.model.getSpimSource(), this.name, this.reuseMipMaps, false, this.interpolate, this.defaultMipMapLevel);
            SourceAndConverter<Volatile<T>> vsac = new SourceAndConverter<Volatile<T>>(vsrcResampled, SourceAndConverterHelper.cloneConverter(src.asVolatile().getConverter(), src.asVolatile()));
            sac = new SourceAndConverter<T>(srcRsampled, SourceAndConverterHelper.cloneConverter(src.getConverter(), src), vsac);
        } else {
            sac = new SourceAndConverter<T>(srcRsampled, SourceAndConverterHelper.cloneConverter(src.getConverter(), src));
        }
        return sac;
    }
}

