/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.sourceandconverter.transform;

import bdv.img.WarpedSource;
import bdv.viewer.SourceAndConverter;
import java.util.function.Function;
import java.util.function.Supplier;
import net.imglib2.Volatile;
import net.imglib2.realtransform.BoundingBoxEstimation;
import net.imglib2.realtransform.RealTransform;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class SourceRealTransformer<T>
implements Runnable,
Function<SourceAndConverter<T>, SourceAndConverter<T>> {
    SourceAndConverter<T> sourceIn;
    final RealTransform rt;
    BoundingBoxEstimation bbest;
    BoundingBoxEstimation.Method method;
    Supplier<Boolean> cullingMethod = () -> false;

    public SourceRealTransformer(SourceAndConverter<T> src, RealTransform rt) {
        this.sourceIn = src;
        this.rt = rt;
    }

    public SourceRealTransformer(RealTransform rt) {
        this.rt = rt;
    }

    public void setBoundingBoxEstimatorMethod(BoundingBoxEstimation.Method method) {
        this.method = method;
    }

    public void setCulling(Supplier<Boolean> cullingMethod) {
        this.cullingMethod = cullingMethod;
    }

    public void setBoundingBoxEstimator(BoundingBoxEstimation bbest) {
        this.bbest = bbest;
    }

    @Override
    public void run() {
    }

    public SourceAndConverter<T> get() {
        return this.apply(this.sourceIn);
    }

    @Override
    public SourceAndConverter<T> apply(SourceAndConverter<T> in) {
        WarpedSource src;
        if (this.bbest != null) {
            src = new WarpedSource(in.getSpimSource(), "Transformed_" + in.getSpimSource().getName(), this.cullingMethod);
            src.setBoundingBoxEstimator(this.bbest);
        } else if (this.method != null) {
            src = new WarpedSource(in.getSpimSource(), "Transformed_" + in.getSpimSource().getName(), this.cullingMethod);
            src.setBoundingBoxEstimator(new BoundingBoxEstimation(this.method));
        } else {
            src = new WarpedSource(in.getSpimSource(), "Transformed_" + in.getSpimSource().getName(), this.cullingMethod);
            src.setBoundingBoxEstimator(new BoundingBoxEstimation(BoundingBoxEstimation.Method.VOLUME));
        }
        src.updateTransform(this.rt);
        src.setIsTransformed(true);
        if (in.asVolatile() != null) {
            WarpedSource vsrc;
            if (this.bbest != null) {
                vsrc = new WarpedSource(in.asVolatile().getSpimSource(), "Transformed_" + in.asVolatile().getSpimSource().getName(), () -> true);
                vsrc.setBoundingBoxEstimator(this.bbest);
            } else if (this.method != null) {
                vsrc = new WarpedSource(in.asVolatile().getSpimSource(), "Transformed_" + in.asVolatile().getSpimSource().getName(), () -> true);
                vsrc.setBoundingBoxEstimator(new BoundingBoxEstimation(this.method));
            } else {
                vsrc = new WarpedSource(in.asVolatile().getSpimSource(), "Transformed_" + in.asVolatile().getSpimSource().getName(), () -> false);
                vsrc.setBoundingBoxEstimator(new BoundingBoxEstimation(BoundingBoxEstimation.Method.VOLUME));
            }
            vsrc.updateTransform(this.rt);
            vsrc.setIsTransformed(true);
            SourceAndConverter<Volatile<T>> vout = new SourceAndConverter<Volatile<T>>(vsrc, SourceAndConverterHelper.cloneConverter(in.asVolatile().getConverter(), in.asVolatile()));
            return new SourceAndConverter<T>(src, SourceAndConverterHelper.cloneConverter(in.getConverter(), in), vout);
        }
        return new SourceAndConverter<T>(src, SourceAndConverterHelper.cloneConverter(in.getConverter(), in));
    }
}

