/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.sourceandconverter.transform;

import bdv.tools.transformation.TransformedSource;
import bdv.viewer.SourceAndConverter;
import java.util.function.Function;
import net.imglib2.Volatile;
import net.imglib2.realtransform.AffineTransform3D;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class SourceAffineTransformer<T>
implements Runnable,
Function<SourceAndConverter<T>, SourceAndConverter<T>> {
    SourceAndConverter<T> sourceIn;
    final AffineTransform3D at3D;

    public SourceAffineTransformer(SourceAndConverter<T> src, AffineTransform3D at3D) {
        this.sourceIn = src;
        this.at3D = at3D;
    }

    public SourceAffineTransformer(AffineTransform3D at3D) {
        this.at3D = at3D;
    }

    @Override
    public void run() {
    }

    public SourceAndConverter<T> get() {
        return this.apply(this.sourceIn);
    }

    @Override
    public SourceAndConverter<T> apply(SourceAndConverter<T> in) {
        SourceAndConverter<T> sac;
        TransformedSource<T> src = new TransformedSource<T>(in.getSpimSource());
        src.setFixedTransform(this.at3D);
        if (in.asVolatile() != null) {
            TransformedSource<Volatile<T>> vsrc = new TransformedSource<Volatile<T>>(in.asVolatile().getSpimSource(), src);
            SourceAndConverter<Volatile<T>> vout = new SourceAndConverter<Volatile<T>>(vsrc, SourceAndConverterHelper.cloneConverter(in.asVolatile().getConverter(), in.asVolatile()));
            sac = new SourceAndConverter<T>(src, SourceAndConverterHelper.cloneConverter(in.getConverter(), in), vout);
        } else {
            sac = new SourceAndConverter<T>(src, SourceAndConverterHelper.cloneConverter(in.getConverter(), in));
        }
        return sac;
    }
}

