/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.sourceandconverter.register;

import bdv.gui.BigWarpViewerOptions;
import bdv.tools.brightness.ConverterSetup;
import bdv.util.BdvHandle;
import bdv.util.ViewerPanelHandle;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerPanel;
import bigwarp.BigWarp;
import bigwarp.BigWarpData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.SpimDataException;

public class BigWarpLauncher
implements Runnable {
    final BigWarpData<?> bwData;
    BigWarp<?> bigWarp;
    final String bigWarpName;
    BdvHandle bdvHandleP;
    BdvHandle bdvHandleQ;
    final List<SourceAndConverter<?>> movingSources;
    SourceAndConverter<?> gridSource;
    SourceAndConverter<?> warpMagnitudeSource;
    SourceAndConverter<?>[] warpedSources;
    final Map<ConverterSetup, double[]> displaysettings = new HashMap<ConverterSetup, double[]>();
    boolean force2d = false;

    public BigWarpLauncher(List<SourceAndConverter<?>> movingSources, List<SourceAndConverter<?>> fixedSources, String bigWarpName, List<ConverterSetup> allConverterSetups) {
        this.movingSources = movingSources;
        this.bigWarpName = bigWarpName;
        ArrayList allSources = new ArrayList();
        allSources.addAll(movingSources);
        allSources.addAll(fixedSources);
        int[] mvSrcIndices = new int[movingSources.size()];
        for (int i = 0; i < movingSources.size(); ++i) {
            mvSrcIndices[i] = i;
        }
        int[] fxSrcIndices = new int[fixedSources.size()];
        for (int i = 0; i < fixedSources.size(); ++i) {
            fxSrcIndices[i] = i + movingSources.size();
        }
        if (allConverterSetups == null) {
            allConverterSetups = new ArrayList<ConverterSetup>();
        }
        allConverterSetups.forEach(setup -> this.displaysettings.put((ConverterSetup)setup, new double[]{setup.getDisplayRangeMin(), setup.getDisplayRangeMax()}));
        this.bwData = new BigWarpData(allSources, allConverterSetups, null, mvSrcIndices, fxSrcIndices);
    }

    public void set2d() {
        this.force2d = true;
    }

    @Override
    public void run() {
        try {
            this.bigWarp = this.force2d ? new BigWarp(this.bwData, this.bigWarpName, BigWarpViewerOptions.options().is2D(true), null) : new BigWarp(this.bwData, this.bigWarpName, null);
            this.bdvHandleP = new ViewerPanelHandle((ViewerPanel)this.bigWarp.getViewerFrameP().getViewerPanel(), this.bigWarpName + "_Moving");
            this.bdvHandleQ = new ViewerPanelHandle((ViewerPanel)this.bigWarp.getViewerFrameQ().getViewerPanel(), this.bigWarpName + "_Fixed");
            this.warpedSources = new SourceAndConverter[this.movingSources.size()];
            for (int i = 0; i < this.warpedSources.length; ++i) {
                this.warpedSources[i] = this.bdvHandleP.getViewerPanel().state().getSources().get(i);
            }
            int nSources = this.bdvHandleP.getViewerPanel().state().getSources().size();
            this.gridSource = this.bdvHandleP.getViewerPanel().state().getSources().get(nSources - 1);
            this.warpMagnitudeSource = this.bdvHandleP.getViewerPanel().state().getSources().get(nSources - 2);
            this.displaysettings.keySet().forEach(setup -> setup.setDisplayRange(this.displaysettings.get(setup)[0], this.displaysettings.get(setup)[1]));
        }
        catch (SpimDataException e) {
            e.printStackTrace();
        }
    }

    public BdvHandle getBdvHandleP() {
        return this.bdvHandleP;
    }

    public BdvHandle getBdvHandleQ() {
        return this.bdvHandleQ;
    }

    public BigWarp<?> getBigWarp() {
        return this.bigWarp;
    }

    public SourceAndConverter<?> getGridSource() {
        return this.gridSource;
    }

    public SourceAndConverter<?> getWarpMagnitudeSource() {
        return this.warpMagnitudeSource;
    }

    public SourceAndConverter<?>[] getWarpedSources() {
        return this.warpedSources;
    }
}

