/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.sourceandconverter.importer;

import bdv.util.RandomAccessibleIntervalSource;
import bdv.viewer.SourceAndConverter;
import java.util.Random;
import java.util.function.Supplier;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.KDTree;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealPoint;
import net.imglib2.RealPointSampleList;
import net.imglib2.RealRandomAccessible;
import net.imglib2.algorithm.util.Grids;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.neighborsearch.NearestNeighborSearchInterpolatorFactory;
import net.imglib2.neighborsearch.NearestNeighborSearchOnKDTree;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.RandomAccessibleOnRealRandomAccessible;
import net.imglib2.view.Views;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class VoronoiSourceGetter
implements Runnable,
Supplier<SourceAndConverter<?>> {
    final long[] imgSize;
    final int numPts;
    final boolean copyImg;

    public VoronoiSourceGetter(long[] imgSize, int numPts, boolean copyImg) {
        this.imgSize = imgSize;
        this.numPts = numPts;
        this.copyImg = copyImg;
    }

    @Override
    public void run() {
    }

    @Override
    public SourceAndConverter<FloatType> get() {
        RandomAccessibleInterval<FloatType> voronoi = VoronoiSourceGetter.getVoronoiTestLabelImage(this.imgSize, this.numPts, this.copyImg);
        RandomAccessibleIntervalSource s = new RandomAccessibleIntervalSource(voronoi, (NumericType)new FloatType(), new AffineTransform3D(), "Voronoi_" + this.numPts + " Pts_[" + this.imgSize[0] + "," + this.imgSize[1] + "," + this.imgSize[2] + "]");
        return SourceAndConverterHelper.createSourceAndConverter(s);
    }

    public static RandomAccessibleInterval<FloatType> getVoronoiTestLabelImage(long[] imgTestSize, int numPts, boolean copyImg) {
        FinalInterval interval = new FinalInterval(imgTestSize);
        RealPointSampleList<FloatType> realInterval = VoronoiSourceGetter.createRandomPoints((RealInterval)interval, numPts);
        NearestNeighborSearchOnKDTree search = new NearestNeighborSearchOnKDTree(new KDTree(realInterval));
        RealRandomAccessible realRandomAccessible = Views.interpolate((EuclideanSpace)search, (InterpolatorFactory)new NearestNeighborSearchInterpolatorFactory());
        RandomAccessibleOnRealRandomAccessible randomAccessible = Views.raster((RealRandomAccessible)realRandomAccessible);
        IntervalView labelImage = Views.interval((RandomAccessible)randomAccessible, (Interval)interval);
        if (copyImg) {
            ArrayImg labelImageCopy = new ArrayImgFactory((NativeType)new FloatType()).create((Dimensions)labelImage);
            Grids.collectAllContainedIntervals((long[])imgTestSize, (int[])new int[]{64, 64, 64}).forEach(arg_0 -> VoronoiSourceGetter.lambda$getVoronoiTestLabelImage$0((RandomAccessibleInterval)labelImage, labelImageCopy, arg_0));
            return labelImageCopy;
        }
        return labelImage;
    }

    public static <T extends Type<T>> void copy(RandomAccessible<T> source, IterableInterval<T> target) {
        Cursor targetCursor = target.localizingCursor();
        RandomAccess sourceRandomAccess = source.randomAccess();
        while (targetCursor.hasNext()) {
            targetCursor.fwd();
            sourceRandomAccess.setPosition((Localizable)targetCursor);
            ((Type)targetCursor.get()).set((Type)sourceRandomAccess.get());
        }
    }

    public static RealPointSampleList<FloatType> createRandomPoints(RealInterval interval, int numPoints) {
        int numDimensions = interval.numDimensions();
        Random rnd = new Random(2001L);
        RealPointSampleList elements = new RealPointSampleList(numDimensions);
        for (int i = 0; i < numPoints; ++i) {
            RealPoint point = new RealPoint(numDimensions);
            for (int d = 0; d < numDimensions; ++d) {
                point.setPosition(rnd.nextDouble() * (interval.realMax(d) - interval.realMin(d)) + interval.realMin(d), d);
            }
            elements.add(point, (Object)new FloatType(rnd.nextFloat() * 255.0f));
        }
        return elements;
    }

    private static /* synthetic */ void lambda$getVoronoiTestLabelImage$0(RandomAccessibleInterval labelImage, ArrayImg labelImageCopy, Interval blockinterval) {
        VoronoiSourceGetter.copy(labelImage, Views.interval((RandomAccessible)labelImageCopy, (Interval)blockinterval));
    }
}

