/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.sourceandconverter.importer;

import bdv.SpimSource;
import bdv.ViewerImgLoader;
import bdv.VolatileSpimSource;
import bdv.spimdata.WrapBasicImgLoader;
import bdv.viewer.SourceAndConverter;
import java.util.HashMap;
import java.util.Map;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicMultiResolutionSetupImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class SourceAndConverterFromSpimDataCreator {
    protected static final Logger logger = LoggerFactory.getLogger(SourceAndConverterFromSpimDataCreator.class);
    private final AbstractSpimData<?> asd;
    private final Map<Integer, SourceAndConverter<?>> setupIdToSourceAndConverter;
    private final Map<SourceAndConverter<?>, Map<String, Object>> sourceAndConverterToMetadata;

    public SourceAndConverterFromSpimDataCreator(AbstractSpimData<?> asd) {
        this.asd = asd;
        this.setupIdToSourceAndConverter = new HashMap();
        this.sourceAndConverterToMetadata = new HashMap();
        this.createSourceAndConverters();
    }

    public Map<Integer, SourceAndConverter<?>> getSetupIdToSourceAndConverter() {
        return this.setupIdToSourceAndConverter;
    }

    public Map<String, Object> getMetadata(SourceAndConverter<?> sourceAndConverter) {
        return this.sourceAndConverterToMetadata.get(sourceAndConverter);
    }

    private void createSourceAndConverters() {
        boolean nonVolatile = WrapBasicImgLoader.wrapImgLoaderIfNecessary(this.asd);
        if (nonVolatile) {
            System.err.println("WARNING:\nOpening <SpimData> dataset that is not suited for interactive browsing.\nConsider resaving as HDF5 for better performance.");
        }
        AbstractSequenceDescription seq = this.asd.getSequenceDescription();
        ViewerImgLoader imgLoader = (ViewerImgLoader)seq.getImgLoader();
        for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
            int setupId = setup.getId();
            BasicMultiResolutionSetupImgLoader vsil = imgLoader.getSetupImgLoader(setupId);
            String sourceName = SourceAndConverterFromSpimDataCreator.createSetupName(setup);
            Object type = vsil.getImageType();
            if (type instanceof RealType) {
                this.createRealTypeSourceAndConverter(nonVolatile, setupId, sourceName);
            } else if (type instanceof ARGBType) {
                this.createARGBTypeSourceAndConverter(setupId, sourceName);
            } else {
                logger.error("Cannot open Spimdata with Source of type " + type.getClass().getSimpleName());
            }
            this.sourceAndConverterToMetadata.put(this.setupIdToSourceAndConverter.get(setupId), new HashMap());
        }
        WrapBasicImgLoader.removeWrapperIfPresent(this.asd);
    }

    private void createRealTypeSourceAndConverter(boolean nonVolatile, int setupId, String sourceName) {
        SpimSource s = new SpimSource(this.asd, setupId, sourceName);
        Converter<RealType, ARGBType> nonVolatileConverter = SourceAndConverterHelper.createConverterRealType((RealType)s.getType());
        if (!nonVolatile) {
            VolatileSpimSource vs = new VolatileSpimSource(this.asd, setupId, sourceName);
            Converter<RealType, ARGBType> volatileConverter = SourceAndConverterHelper.createConverterRealType((RealType)vs.getType());
            this.setupIdToSourceAndConverter.put(setupId, new SourceAndConverter<RealType>(s, nonVolatileConverter, new SourceAndConverter<RealType>(vs, volatileConverter)));
        } else {
            this.setupIdToSourceAndConverter.put(setupId, new SourceAndConverter<RealType>(s, nonVolatileConverter));
        }
    }

    private void createARGBTypeSourceAndConverter(int setupId, String sourceName) {
        VolatileSpimSource vs = new VolatileSpimSource(this.asd, setupId, sourceName);
        SpimSource s = new SpimSource(this.asd, setupId, sourceName);
        Converter<?, ARGBType> nonVolatileConverter = SourceAndConverterHelper.createConverterARGBType(s);
        Converter<?, ARGBType> volatileConverter = SourceAndConverterHelper.createConverterARGBType(vs);
        this.setupIdToSourceAndConverter.put(setupId, new SourceAndConverter(s, nonVolatileConverter, new SourceAndConverter(vs, volatileConverter)));
    }

    private static String createSetupName(BasicViewSetup setup) {
        Channel channel;
        if (setup.hasName() && !setup.getName().trim().equals("")) {
            return setup.getName();
        }
        String name = "";
        Angle angle = (Angle)setup.getAttribute(Angle.class);
        if (angle != null) {
            name = name + "a " + angle.getName();
        }
        if ((channel = (Channel)setup.getAttribute(Channel.class)) != null) {
            name = name + (name.isEmpty() ? "" : " ") + "c " + channel.getName();
        }
        if (channel == null && angle == null) {
            name = name + "id " + setup.getId();
        }
        return name;
    }
}

