/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.sourceandconverter.importer;

import bdv.util.Procedural3DImageShort;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import java.util.function.Supplier;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class MandelbrotSourceGetter
implements Runnable,
Supplier<SourceAndConverter<UnsignedShortType>> {
    final int maxIterations = 255;

    @Override
    public void run() {
    }

    @Override
    public SourceAndConverter<UnsignedShortType> get() {
        Source<UnsignedShortType> s = new Procedural3DImageShort(p -> {
            double squim;
            double squre;
            int i;
            double re = p[0];
            double im = p[1];
            for (i = 0; i < 255 && !((squre = re * re) + (squim = im * im) > 4.0); ++i) {
                im = 2.0 * re * im + p[1];
                re = squre - squim + p[0];
            }
            return i;
        }).getSource("Mandelbrot Set");
        return SourceAndConverterHelper.createSourceAndConverter(s);
    }
}

