/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.sourceandconverter.importer;

import bdv.util.EmptySource;
import bdv.viewer.SourceAndConverter;
import java.util.function.Supplier;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class EmptySourceAndConverterCreator
implements Runnable,
Supplier<SourceAndConverter<?>> {
    private final AffineTransform3D at3D;
    private final long nx;
    private final long ny;
    private final long nz;
    private final String name;
    private final VoxelDimensions voxelDimensions;
    private static final VoxelDimensions defaultVoxelDimensions = new FinalVoxelDimensions("pixel", new double[]{1.0, 1.0, 1.0});

    public EmptySourceAndConverterCreator(String name, RealInterval interval, double sizeVoxX, double sizeVoxY, double sizeVoxZ) {
        this.name = name;
        AffineTransform3D at3D = new AffineTransform3D();
        this.nx = (long)((interval.realMax(0) - interval.realMin(0)) / sizeVoxX);
        this.ny = (long)((interval.realMax(1) - interval.realMin(1)) / sizeVoxY);
        this.nz = (long)((interval.realMax(2) - interval.realMin(2)) / sizeVoxZ);
        at3D.scale(sizeVoxX, sizeVoxY, sizeVoxZ);
        at3D.translate(new double[]{interval.realMin(0), interval.realMin(1), interval.realMin(2)});
        this.at3D = at3D;
        this.voxelDimensions = defaultVoxelDimensions;
    }

    public EmptySourceAndConverterCreator(String name, RealInterval interval, long nx, long ny, long nz) {
        this(name, interval, nx, ny, nz, defaultVoxelDimensions);
    }

    public EmptySourceAndConverterCreator(String name, RealInterval interval, long nx, long ny, long nz, VoxelDimensions voxelDimensions) {
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
        this.name = name;
        AffineTransform3D at3D = new AffineTransform3D();
        double sizePx = (interval.realMax(0) - interval.realMin(0)) / (double)nx;
        double sizePy = (interval.realMax(1) - interval.realMin(1)) / (double)ny;
        double sizePz = (interval.realMax(2) - interval.realMin(2)) / (double)nz;
        at3D.scale(sizePx, sizePy, sizePz);
        at3D.translate(new double[]{interval.realMin(0), interval.realMin(1), interval.realMin(2)});
        this.at3D = at3D;
        this.voxelDimensions = voxelDimensions;
    }

    public EmptySourceAndConverterCreator(String name, AffineTransform3D at3D, long nx, long ny, long nz) {
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
        this.at3D = at3D;
        this.name = name;
        this.voxelDimensions = defaultVoxelDimensions;
    }

    public EmptySourceAndConverterCreator(String name, SourceAndConverter<?> model, int timePoint, double voxSizeX, double voxSizeY, double voxSizeZ) {
        this.voxelDimensions = defaultVoxelDimensions;
        RandomAccessibleInterval<?> rai = model.getSpimSource().getSource(timePoint, 0);
        long nPixModelX = rai.dimension(0);
        long nPixModelY = rai.dimension(1);
        long nPixModelZ = rai.dimension(2);
        AffineTransform3D at3Dorigin = new AffineTransform3D();
        model.getSpimSource().getSourceTransform(timePoint, 0, at3Dorigin);
        double[] x0 = new double[3];
        at3Dorigin.apply(new double[]{0.0, 0.0, 0.0}, x0);
        double[] pt = new double[3];
        at3Dorigin.apply(new double[]{1.0, 0.0, 0.0}, pt);
        double dist = (pt[0] - x0[0]) * (pt[0] - x0[0]) + (pt[1] - x0[1]) * (pt[1] - x0[1]) + (pt[2] - x0[2]) * (pt[2] - x0[2]);
        double distx = Math.sqrt(dist);
        dist = Math.sqrt(dist) * (double)nPixModelX;
        double nPixX = dist / voxSizeX;
        at3Dorigin.apply(new double[]{0.0, 1.0, 0.0}, pt);
        dist = (pt[0] - x0[0]) * (pt[0] - x0[0]) + (pt[1] - x0[1]) * (pt[1] - x0[1]) + (pt[2] - x0[2]) * (pt[2] - x0[2]);
        double disty = Math.sqrt(dist);
        dist = Math.sqrt(dist) * (double)nPixModelY;
        double nPixY = dist / voxSizeY;
        at3Dorigin.apply(new double[]{0.0, 0.0, 1.0}, pt);
        dist = (pt[0] - x0[0]) * (pt[0] - x0[0]) + (pt[1] - x0[1]) * (pt[1] - x0[1]) + (pt[2] - x0[2]) * (pt[2] - x0[2]);
        double distz = Math.sqrt(dist);
        dist = Math.sqrt(dist) * (double)nPixModelZ;
        double nPixZ = dist / voxSizeZ;
        double[] m = at3Dorigin.getRowPackedCopy();
        m[0] = m[0] / distx * voxSizeX;
        m[4] = m[4] / distx * voxSizeX;
        m[8] = m[8] / distx * voxSizeX;
        m[1] = m[1] / disty * voxSizeY;
        m[5] = m[5] / disty * voxSizeY;
        m[9] = m[9] / disty * voxSizeY;
        m[2] = m[2] / distz * voxSizeZ;
        m[6] = m[6] / distz * voxSizeZ;
        m[10] = m[10] / distz * voxSizeZ;
        at3Dorigin.set(m);
        this.name = name;
        this.at3D = at3Dorigin;
        this.nx = (long)nPixX;
        this.ny = (long)nPixY;
        this.nz = (long)nPixZ;
    }

    @Override
    public void run() {
    }

    @Override
    public SourceAndConverter<?> get() {
        EmptySource src = new EmptySource(this.nx, this.ny, this.nz, this.at3D, this.name, this.voxelDimensions);
        SourceAndConverter<UnsignedShortType> sac = SourceAndConverterHelper.createSourceAndConverter(src);
        return sac;
    }
}

