/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.sourceandconverter.exporter;

import bdv.export.ExportMipmapInfo;
import bdv.export.ExportScalePyramid;
import bdv.export.ProgressWriter;
import bdv.export.SubTaskProgressWriter;
import bdv.export.WriteSequenceToHdf5;
import bdv.ij.util.ProgressWriterIJ;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.Partition;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import bdv.util.SourceToUnsignedShortConverter;
import bdv.util.sourceimageloader.ImgLoaderFromSources;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Tile;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineTransform3D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlHDF5SpimdataExporter
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(XmlHDF5SpimdataExporter.class);
    final List<SourceAndConverter<?>> sources;
    final int nThreads;
    final int timePointBegin;
    final int timePointEnd;
    int scaleFactor;
    final int blockSizeX;
    final int blockSizeY;
    final int blockSizeZ;
    final int thresholdSizeForMipmap;
    final File xmlFile;
    final String entityType;
    AbstractSpimData<?> spimData;
    final BiConsumer<SourceAndConverter<?>, BasicViewSetup> attributeAdder;

    public XmlHDF5SpimdataExporter(List<SourceAndConverter<?>> sources, String entityType, int nThreads, int timePointBegin, int timePointEnd, int scaleFactor, int blockSizeX, int blockSizeY, int blockSizeZ, int thresholdSizeForMipmap, File xmlFile) {
        this(sources, entityType, nThreads, timePointBegin, timePointEnd, scaleFactor, blockSizeX, blockSizeY, blockSizeZ, thresholdSizeForMipmap, xmlFile, (source, viewsetup) -> {});
    }

    public XmlHDF5SpimdataExporter(List<SourceAndConverter<?>> sources, String entityType, int nThreads, int timePointBegin, int timePointEnd, int scaleFactor, int blockSizeX, int blockSizeY, int blockSizeZ, int thresholdSizeForMipmap, File xmlFile, BiConsumer<SourceAndConverter<?>, BasicViewSetup> attributeAdder) {
        this.sources = sources;
        this.entityType = entityType;
        this.nThreads = nThreads;
        this.timePointBegin = timePointBegin;
        this.timePointEnd = timePointEnd;
        this.scaleFactor = scaleFactor;
        this.blockSizeX = blockSizeX;
        this.blockSizeY = blockSizeY;
        this.blockSizeZ = blockSizeZ;
        this.thresholdSizeForMipmap = thresholdSizeForMipmap;
        this.xmlFile = xmlFile;
        this.attributeAdder = attributeAdder;
    }

    @Override
    public void run() {
        File seqFile;
        File parent;
        HashMap idxSourceToSac = new HashMap();
        List srcs = this.sources.stream().map(SourceAndConverter::getSpimSource).map(SourceToUnsignedShortConverter::convertSource).collect(Collectors.toList());
        for (int i = 0; i < srcs.size(); ++i) {
            idxSourceToSac.put(srcs.get(i), i);
        }
        ImgLoaderFromSources imgLoader = new ImgLoaderFromSources(srcs);
        int numTimepoints = this.timePointEnd - this.timePointBegin;
        int numSetups = srcs.size();
        ArrayList<TimePoint> timepoints = new ArrayList<TimePoint>(numTimepoints);
        for (int t = this.timePointBegin; t < this.timePointEnd; ++t) {
            timepoints.add(new TimePoint(t));
        }
        HashMap<Integer, BasicViewSetup> setups = new HashMap<Integer, BasicViewSetup>(numSetups);
        SequenceDescriptionMinimal seq = new SequenceDescriptionMinimal(new TimePoints(timepoints), (Map<Integer, ? extends BasicViewSetup>)setups, (BasicImgLoader)imgLoader, null);
        HashMap<Integer, ExportMipmapInfo> perSetupExportMipmapInfo = new HashMap<Integer, ExportMipmapInfo>();
        int idx_current_src = 0;
        for (Source src : srcs) {
            RandomAccessibleInterval refRai = src.getSource(0, 0);
            VoxelDimensions voxelSize = src.getVoxelDimensions();
            long[] imgDims = new long[]{refRai.dimension(0), refRai.dimension(1), refRai.dimension(2)};
            FinalDimensions imageSize = new FinalDimensions(imgDims);
            BasicViewSetup basicviewsetup = new BasicViewSetup(idx_current_src, src.getName(), (Dimensions)imageSize, voxelSize);
            int nLevels = 1;
            for (long maxDimension = Math.max(Math.max(imgDims[0], imgDims[1]), imgDims[2]); maxDimension > (long)this.thresholdSizeForMipmap; maxDimension /= (long)(this.scaleFactor + 1)) {
                ++nLevels;
            }
            int[][] resolutions = new int[nLevels][3];
            int[][] subdivisions = new int[nLevels][3];
            for (int iMipMap = 0; iMipMap < nLevels; ++iMipMap) {
                resolutions[iMipMap][0] = imgDims[0] <= 1L ? 1 : (int)Math.pow(this.scaleFactor, iMipMap);
                resolutions[iMipMap][1] = imgDims[1] <= 1L ? 1 : (int)Math.pow(this.scaleFactor, iMipMap);
                resolutions[iMipMap][2] = imgDims[2] <= 1L ? 1 : (int)Math.pow(this.scaleFactor, iMipMap);
                subdivisions[iMipMap][0] = (long)((double)imgDims[0] / (double)resolutions[iMipMap][0]) > 1L ? this.blockSizeX : 1;
                subdivisions[iMipMap][1] = (long)((double)imgDims[1] / (double)resolutions[iMipMap][1]) > 1L ? this.blockSizeY : 1;
                subdivisions[iMipMap][2] = (long)((double)imgDims[2] / (double)resolutions[iMipMap][2]) > 1L ? this.blockSizeZ : 1;
                subdivisions[iMipMap][0] = Math.max(1, subdivisions[iMipMap][0]);
                subdivisions[iMipMap][1] = Math.max(1, subdivisions[iMipMap][1]);
                subdivisions[iMipMap][2] = Math.max(1, subdivisions[iMipMap][2]);
            }
            ExportMipmapInfo mipmapSettings = new ExportMipmapInfo(resolutions, subdivisions);
            if (this.entityType.equals("Channel")) {
                basicviewsetup.setAttribute((Entity)new Channel(idx_current_src + 1));
            } else if (this.entityType.equals("Tile")) {
                basicviewsetup.setAttribute((Entity)new Tile(idx_current_src + 1));
            }
            SourceAndConverter<?> sac = this.sources.get((Integer)idxSourceToSac.get(src));
            this.attributeAdder.accept(sac, basicviewsetup);
            setups.put(idx_current_src, basicviewsetup);
            ExportMipmapInfo mipmapInfo = new ExportMipmapInfo(mipmapSettings.getExportResolutions(), mipmapSettings.getSubdivisions());
            perSetupExportMipmapInfo.put(basicviewsetup.getId(), mipmapInfo);
            ++idx_current_src;
        }
        int numCellCreatorThreads = Math.max(1, this.nThreads - 1);
        ExportScalePyramid.DefaultLoopbackHeuristic loopbackHeuristic = new ExportScalePyramid.DefaultLoopbackHeuristic();
        ProgressWriterIJ progressWriter = new ProgressWriterIJ();
        logger.info("Starting export...");
        ExportScalePyramid.AfterEachPlane afterEachPlane = usedLoopBack -> {};
        ArrayList<Partition> partitions = null;
        String seqFilename = this.xmlFile.getAbsolutePath();
        if (!seqFilename.endsWith(".xml")) {
            seqFilename = seqFilename + ".xml";
        }
        if ((parent = (seqFile = new File(seqFilename)).getParentFile()) == null || !parent.exists() || !parent.isDirectory()) {
            logger.error("Invalid export filename " + seqFilename);
        }
        String hdf5Filename = seqFilename.substring(0, seqFilename.length() - 4) + ".h5";
        File hdf5File = new File(hdf5Filename);
        boolean deflate = true;
        WriteSequenceToHdf5.writeHdf5File(seq, perSetupExportMipmapInfo, deflate, hdf5File, loopbackHeuristic, afterEachPlane, numCellCreatorThreads, new SubTaskProgressWriter((ProgressWriter)progressWriter, 0.0, 0.95));
        SequenceDescriptionMinimal seqh5 = new SequenceDescriptionMinimal(seq, null);
        Hdf5ImageLoader hdf5Loader = new Hdf5ImageLoader(hdf5File, partitions, seqh5, false);
        seqh5.setImgLoader((BasicImgLoader)hdf5Loader);
        ArrayList<ViewRegistration> registrations = new ArrayList<ViewRegistration>();
        for (int t = 0; t < numTimepoints; ++t) {
            for (int s = 0; s < numSetups; ++s) {
                registrations.add(new ViewRegistration(t, s, XmlHDF5SpimdataExporter.getSrcTransform(srcs.get(s), t, 0)));
            }
        }
        File basePath = seqFile.getParentFile();
        this.spimData = new SpimDataMinimal(basePath, seqh5, new ViewRegistrations(registrations));
        try {
            new XmlIoSpimDataMinimal().save((SpimDataMinimal)this.spimData, seqFile.getAbsolutePath());
            progressWriter.setProgress(1.0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.info("Done!");
    }

    public AbstractSpimData<?> get() {
        return this.spimData;
    }

    public File getFile() {
        return this.xmlFile;
    }

    public static AffineTransform3D getSrcTransform(Source<?> src, int timepoint, int level) {
        AffineTransform3D at = new AffineTransform3D();
        src.getSourceTransform(timepoint, level, at);
        return at;
    }
}

