/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.sourceandconverter.display;

import bdv.viewer.SourceAndConverter;
import java.util.function.Consumer;
import net.imglib2.display.ColorConverter;
import net.imglib2.type.numeric.ARGBType;
import sc.fiji.bdvpg.log.SystemLogger;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class ColorChanger
implements Runnable,
Consumer<SourceAndConverter<?>> {
    final SourceAndConverter<?> sac;
    final ARGBType color;

    public ColorChanger(SourceAndConverter<?> sac, ARGBType color) {
        this.sac = sac;
        this.color = color;
    }

    @Override
    public void run() {
        this.accept(this.sac);
    }

    @Override
    public void accept(SourceAndConverter sourceAndConverter) {
        if (sourceAndConverter.getConverter() instanceof ColorConverter) {
            ((ColorConverter)sourceAndConverter.getConverter()).setColor(this.color);
            if (sourceAndConverter.asVolatile() != null) {
                ((ColorConverter)sourceAndConverter.asVolatile().getConverter()).setColor(this.color);
            }
            if (SourceAndConverterServices.getBdvDisplayService() != null) {
                SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(sourceAndConverter).setColor(this.color);
            }
        } else {
            new SystemLogger().err("sourceAndConverter Converter is not an instance of Color Converter");
        }
    }
}

