/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.sourceandconverter.display;

import bdv.tools.brightness.ConverterSetup;
import bdv.viewer.SourceAndConverter;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.histogram.BinMapper1d;
import net.imglib2.histogram.DiscreteFrequencyDistribution;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.histogram.Real1dBinMapper;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class BrightnessAutoAdjuster<T extends RealType<T>>
implements Runnable {
    private final SourceAndConverter<?> sac;
    private final double cumulativeMinCutoff;
    private final double cumulativeMaxCutoff;
    private final int timePoint;

    public BrightnessAutoAdjuster(SourceAndConverter<?> sac, int timePoint) {
        this(sac, timePoint, 0.01, 0.99);
    }

    public BrightnessAutoAdjuster(SourceAndConverter<?> sac, int timePoint, double cumulativeMinCutoff, double cumulativeMaxCutoff) {
        this.sac = sac;
        this.cumulativeMinCutoff = cumulativeMinCutoff;
        this.cumulativeMaxCutoff = cumulativeMaxCutoff;
        this.timePoint = timePoint;
    }

    @Override
    public void run() {
        int i;
        if (!this.sac.getSpimSource().isPresent(this.timePoint)) {
            return;
        }
        if (!(this.sac.getSpimSource().getType() instanceof RealType)) {
            System.out.println("Can't auto adjust brightness of pixel type " + this.sac.getSpimSource().getType().getClass().getSimpleName());
            return;
        }
        RandomAccessibleInterval<?> img = this.sac.getSpimSource().getSource(this.timePoint, this.sac.getSpimSource().getNumMipmapLevels() - 1);
        long zMiddle = (img.min(2) + img.max(2) + 1L) / 2L;
        IterableInterval sampledPixels = Views.iterable((RandomAccessibleInterval)Views.hyperSlice(img, (int)2, (long)zMiddle));
        double minValue = Double.MAX_VALUE;
        double maxValue = -1.7976931348623157E308;
        for (RealType pixel : sampledPixels) {
            double val = pixel.getRealDouble();
            if (val < minValue) {
                minValue = val;
            }
            if (!(val > maxValue)) continue;
            maxValue = val;
        }
        int numBins = 6535;
        Histogram1d histogram = new Histogram1d((Iterable)sampledPixels, (BinMapper1d)new Real1dBinMapper(minValue, maxValue, 6535L, false));
        DiscreteFrequencyDistribution dfd = histogram.dfd();
        long[] bin = new long[]{0L};
        double cumulative = 0.0;
        for (i = 0; i < 6535 && cumulative < this.cumulativeMinCutoff; cumulative += dfd.relativeFrequency(bin), ++i) {
            bin[0] = i;
        }
        double min = (double)i / 6535.0 * (maxValue - minValue) + minValue;
        while (i < 6535 && cumulative < this.cumulativeMaxCutoff) {
            bin[0] = i;
            cumulative += dfd.relativeFrequency(bin);
            ++i;
        }
        double max = (double)(++i) / 6535.0 * (maxValue - minValue) + minValue;
        ConverterSetup converterSetup = SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(this.sac);
        converterSetup.setDisplayRange(min, max);
    }
}

