/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.sourceandconverter;

import bdv.AbstractSpimSource;
import bdv.BigDataViewer;
import bdv.img.WarpedSource;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.transformation.TransformedSource;
import bdv.util.BdvHandle;
import bdv.util.LUTConverterSetup;
import bdv.util.ResampledSource;
import bdv.util.UnmodifiableConverterSetup;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.Volatile;
import net.imglib2.converter.Converter;
import net.imglib2.converter.RealLUTConverter;
import net.imglib2.display.ColorConverter;
import net.imglib2.display.RealARGBColorConverter;
import net.imglib2.display.ScaledARGBConverter;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.volatiles.VolatileARGBType;
import net.imglib2.util.Intervals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.ICloneableConverter;

public class SourceAndConverterHelper {
    protected static final Logger logger = LoggerFactory.getLogger(SourceAndConverterHelper.class);

    public static <T> SourceAndConverter<T> createSourceAndConverter(Source<T> source) {
        if (source.getType() instanceof RealType) {
            return SourceAndConverterHelper.createSourceAndConverterRealType(source);
        }
        if (source.getType() instanceof ARGBType) {
            return SourceAndConverterHelper.createSourceAndConverterARGBType(source);
        }
        logger.error("Cannot create SourceAndConverter and converter for sources of type " + source.getType());
        return null;
    }

    private static <T extends RealType<T>, V extends Volatile<T>> SourceAndConverter<T> createSourceAndConverterRealType(Source<T> source) {
        Converter<RealType, ARGBType> nonVolatileConverter = SourceAndConverterHelper.createConverterRealType((RealType)source.getType());
        try {
            Source<V> volatileSource = SourceAndConverterHelper.createVolatileRealType(source);
            Converter<RealType, ARGBType> volatileConverter = SourceAndConverterHelper.createConverterRealType((RealType)volatileSource.getType());
            return new SourceAndConverter<RealType>(source, nonVolatileConverter, new SourceAndConverter<RealType>(volatileSource, volatileConverter));
        }
        catch (Exception e) {
            return new SourceAndConverter<RealType>(source, nonVolatileConverter);
        }
    }

    private static SourceAndConverter<ARGBType> createSourceAndConverterARGBType(Source<ARGBType> source) {
        ScaledARGBConverter.ARGB nonVolatileConverter = new ScaledARGBConverter.ARGB(0.0, 255.0);
        try {
            Source<VolatileARGBType> volatileSource = SourceAndConverterHelper.createVolatileARGBType(source);
            ScaledARGBConverter.VolatileARGB volatileConverter = new ScaledARGBConverter.VolatileARGB(0.0, 255.0);
            return new SourceAndConverter<ARGBType>(source, nonVolatileConverter, new SourceAndConverter<VolatileARGBType>(volatileSource, volatileConverter));
        }
        catch (Exception e) {
            return new SourceAndConverter<ARGBType>(source, nonVolatileConverter);
        }
    }

    public static <T> Converter<T, ARGBType> createConverter(Source<? extends T> source) {
        if (source.getType() instanceof RealType) {
            return SourceAndConverterHelper.createConverterRealType((RealType)source.getType());
        }
        if (source.getType() instanceof ARGBType) {
            return SourceAndConverterHelper.createConverterARGBType(source);
        }
        logger.error("Cannot create converter for SourceAndConverter of type " + source.getType().getClass().getSimpleName());
        return null;
    }

    public static <I, O> Converter<I, O> cloneConverter(Converter<I, O> converter, SourceAndConverter<?> sac) {
        if (converter instanceof ICloneableConverter) {
            return ((ICloneableConverter)converter).duplicateConverter(sac);
        }
        if (converter instanceof ScaledARGBConverter.VolatileARGB) {
            return new ScaledARGBConverter.VolatileARGB(((ScaledARGBConverter.VolatileARGB)converter).getMin(), ((ScaledARGBConverter.VolatileARGB)converter).getMax());
        }
        if (converter instanceof ScaledARGBConverter.ARGB) {
            return new ScaledARGBConverter.ARGB(((ScaledARGBConverter.ARGB)converter).getMin(), ((ScaledARGBConverter.ARGB)converter).getMax());
        }
        if (converter instanceof RealLUTConverter) {
            return new RealLUTConverter(((RealLUTConverter)converter).getMin(), ((RealLUTConverter)converter).getMax(), ((RealLUTConverter)converter).getLUT());
        }
        Converter<NumericType, ARGBType> clonedConverter = BigDataViewer.createConverterToARGB((NumericType)sac.getSpimSource().getType());
        if (clonedConverter != null) {
            if (converter instanceof ColorConverter && clonedConverter instanceof ColorConverter) {
                ((ColorConverter)clonedConverter).setColor(((ColorConverter)converter).getColor());
                ((ColorConverter)clonedConverter).setMin(((ColorConverter)converter).getMin());
                ((ColorConverter)clonedConverter).setMax(((ColorConverter)converter).getMax());
            }
            return clonedConverter;
        }
        logger.error("Could not clone the converter of class " + converter.getClass().getSimpleName());
        return null;
    }

    public static ConverterSetup createConverterSetup(SourceAndConverter<?> sac) {
        if (sac.getConverter() instanceof ColorConverter) {
            return BigDataViewer.createConverterSetup(sac, -1);
        }
        if (sac.getConverter() instanceof RealLUTConverter) {
            if (sac.asVolatile() != null) {
                return new LUTConverterSetup((RealLUTConverter)sac.getConverter(), (RealLUTConverter)sac.asVolatile().getConverter());
            }
            return new LUTConverterSetup((RealLUTConverter)sac.getConverter());
        }
        logger.debug("Unmodifiable ConverterSetup for Converters of class " + sac.getConverter().getClass());
        if (sac.asVolatile() != null) {
            return new UnmodifiableConverterSetup(sac.getConverter(), sac.asVolatile().getConverter());
        }
        return new UnmodifiableConverterSetup(sac.getConverter());
    }

    private static <T, V extends Volatile<T>> Source<V> createVolatileRealType(Source<T> source) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Unimplemented createVolatileRealType method in SourceAndConverterHelper");
    }

    private static Source<VolatileARGBType> createVolatileARGBType(Source<ARGBType> source) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Unimplemented createVolatileARGBType method in SourceAndConverterHelper");
    }

    public static <T extends RealType<T>> Converter<T, ARGBType> createConverterRealType(T type) {
        double typeMin = Math.max(0.0, Math.min(type.getMinValue(), 65535.0));
        double typeMax = Math.max(0.0, Math.min(type.getMaxValue(), 65535.0));
        RealARGBColorConverter<T> converter = RealARGBColorConverter.create(type, typeMin, typeMax);
        converter.setColor(new ARGBType(-1));
        return converter;
    }

    public static Converter<?, ARGBType> createConverterARGBType(Source<?> source) {
        ScaledARGBConverter converter = source.getType() instanceof Volatile ? new ScaledARGBConverter.VolatileARGB(0.0, 255.0) : new ScaledARGBConverter.ARGB(0.0, 255.0);
        return converter;
    }

    public static boolean isPositionWithinSourceInterval(SourceAndConverter<?> source, RealPoint globalPosition, int timepoint, boolean sourceIs2d) {
        Source<?> spimSource = source.getSpimSource();
        long[] voxelPositionInSource = SourceAndConverterHelper.getVoxelPositionInSource(spimSource, globalPosition, timepoint, 0);
        RandomAccessibleInterval<?> sourceInterval = spimSource.getSource(timepoint, 0);
        if (sourceIs2d) {
            long[] min = new long[2];
            long[] max = new long[2];
            long[] positionInSource2D = new long[2];
            for (int d = 0; d < 2; ++d) {
                min[d] = sourceInterval.min(d);
                max[d] = sourceInterval.max(d);
                positionInSource2D[d] = voxelPositionInSource[d];
            }
            FinalInterval interval2d = new FinalInterval(min, max);
            Point point2d = new Point(positionInSource2D);
            return Intervals.contains((Interval)interval2d, (Localizable)point2d);
        }
        Point point3d = new Point(voxelPositionInSource);
        return Intervals.contains(sourceInterval, (Localizable)point3d);
    }

    public static long[] getVoxelPositionInSource(Source<?> source, RealPoint globalPosition, int t, int level) {
        int numDimensions = 3;
        AffineTransform3D sourceTransform = BdvHandleHelper.getSourceTransform(source, t, level);
        RealPoint voxelPositionInSource = new RealPoint(3);
        sourceTransform.inverse().apply((RealLocalizable)globalPosition, (RealPositionable)voxelPositionInSource);
        long[] longPosition = new long[3];
        for (int d = 0; d < 3; ++d) {
            longPosition[d] = (long)voxelPositionInSource.getFloatPosition(d);
        }
        return longPosition;
    }

    public static int getMaxTimepoint(SourceAndConverter<?>[] sacs) {
        int max = 0;
        for (SourceAndConverter<?> sac : sacs) {
            int sourceMax = SourceAndConverterHelper.getMaxTimepoint(sac);
            if (sourceMax <= max) continue;
            max = sourceMax;
        }
        return max;
    }

    public static int getNTimepoints(SourceAndConverter<?>[] sacs) {
        int max = 0;
        for (SourceAndConverter<?> sac : sacs) {
            int sourceMax;
            if (sac.getSpimSource().isPresent(-1) || (sourceMax = SourceAndConverterHelper.getMaxTimepoint(sac)) <= max) continue;
            max = sourceMax;
        }
        return max;
    }

    public static int getMaxTimepoint(Source<?>[] sacs) {
        int max = 0;
        for (Source<?> source : sacs) {
            int sourceMax = SourceAndConverterHelper.getMaxTimepoint(source);
            if (sourceMax <= max) continue;
            max = sourceMax;
        }
        return max;
    }

    public static int getMaxTimepoint(Source<?> source) {
        int iFrame;
        if (!source.isPresent(0)) {
            return 0;
        }
        int nFrames = 1;
        int previous = iFrame = 1;
        while (iFrame < 0x3FFFFFFF && source.isPresent(iFrame)) {
            previous = iFrame;
            iFrame *= 2;
        }
        if (iFrame > 1) {
            for (int tp = previous; tp < iFrame + 1; ++tp) {
                if (source.isPresent(tp)) continue;
                nFrames = tp;
                break;
            }
        }
        return nFrames;
    }

    public static int getMaxTimepoint(SourceAndConverter<?> sac) {
        return SourceAndConverterHelper.getMaxTimepoint(sac.getSpimSource());
    }

    public static <T> boolean isSourcePresentAt(SourceAndConverter<T> sac, int timePoint, RealPoint pt) {
        RealRandomAccessible<T> rra_ible = sac.getSpimSource().getInterpolatedSource(timePoint, 0, Interpolation.NEARESTNEIGHBOR);
        if (rra_ible != null) {
            AffineTransform3D sourceTransform = new AffineTransform3D();
            sac.getSpimSource().getSourceTransform(timePoint, 0, sourceTransform);
            RealRandomAccess rra = rra_ible.realRandomAccess();
            RealPoint iPt = new RealPoint(3);
            sourceTransform.inverse().apply((RealLocalizable)pt, (RealPositionable)iPt);
            rra.setPosition((RealLocalizable)iPt);
            Converter<T, ARGBType> cvt = sac.getConverter();
            ARGBType colorOut = new ARGBType();
            cvt.convert(rra.get(), (Object)colorOut);
            int cValue = colorOut.get();
            return ARGBType.alpha((int)cValue) != 0;
        }
        return false;
    }

    public static SourceAndConverter<?>[] sortDefault(SourceAndConverter<?>[] sacs) {
        return SourceAndConverterHelper.sortDefaultGeneric(Arrays.asList(sacs)).toArray(new SourceAndConverter[0]);
    }

    public static List<SourceAndConverter<?>> sortDefaultGeneric(Collection<SourceAndConverter<?>> sacs) {
        ArrayList sortedList = new ArrayList(sacs.size());
        sortedList.addAll(sacs);
        Comparator sacComparator = (s1, s2) -> {
            SourceAndConverterService.SpimDataInfo sdi1 = null;
            SourceAndConverterService.SpimDataInfo sdi2 = null;
            if (SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter<?>)s1, "SPIMDATA") != null) {
                sdi1 = (SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter<?>)s1, "SPIMDATA");
            }
            if (SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter<?>)s2, "SPIMDATA") != null) {
                sdi2 = (SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter<?>)s2, "SPIMDATA");
            }
            if (sdi1 == null && sdi2 != null) {
                return -1;
            }
            if (sdi1 != null && sdi2 == null) {
                return 1;
            }
            if (sdi1 != null) {
                if (sdi1.asd == sdi2.asd) {
                    return sdi1.setupId - sdi2.setupId;
                }
                return sdi2.toString().compareTo(sdi1.toString());
            }
            return s2.getSpimSource().getName().compareTo(s1.getSpimSource().getName());
        };
        sortedList.sort(sacComparator);
        return sortedList;
    }

    @Deprecated
    public static List<SourceAndConverter> sortDefaultNoGeneric(Collection<SourceAndConverter> sacs) {
        ArrayList<SourceAndConverter> sortedList = new ArrayList<SourceAndConverter>(sacs.size());
        sortedList.addAll(sacs);
        Comparator sacComparator = (s1, s2) -> {
            SourceAndConverterService.SpimDataInfo sdi1 = null;
            SourceAndConverterService.SpimDataInfo sdi2 = null;
            if (SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter<?>)s1, "SPIMDATA") != null) {
                sdi1 = (SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter<?>)s1, "SPIMDATA");
            }
            if (SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter<?>)s2, "SPIMDATA") != null) {
                sdi2 = (SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter<?>)s2, "SPIMDATA");
            }
            if (sdi1 == null && sdi2 != null) {
                return -1;
            }
            if (sdi1 != null && sdi2 == null) {
                return 1;
            }
            if (sdi1 != null) {
                if (sdi1.asd == sdi2.asd) {
                    return sdi1.setupId - sdi2.setupId;
                }
                return sdi2.toString().compareTo(sdi1.toString());
            }
            return s2.getSpimSource().getName().compareTo(s1.getSpimSource().getName());
        };
        sortedList.sort(sacComparator);
        return sortedList;
    }

    public static RealPoint getSourceAndConverterCenterPoint(SourceAndConverter<?> source, int timepoint) {
        AffineTransform3D sourceTransform = new AffineTransform3D();
        sourceTransform.identity();
        source.getSpimSource().getSourceTransform(timepoint, 0, sourceTransform);
        long[] dims = new long[3];
        source.getSpimSource().getSource(timepoint, 0).dimensions(dims);
        RealPoint ptCenterGlobal = new RealPoint(3);
        RealPoint ptCenterPixel = new RealPoint(new double[]{((double)dims[0] - 1.0) / 2.0, ((double)dims[1] - 1.0) / 2.0, ((double)dims[2] - 1.0) / 2.0});
        sourceTransform.apply((RealLocalizable)ptCenterPixel, (RealPositionable)ptCenterGlobal);
        return ptCenterGlobal;
    }

    public static void transferColorConverters(SourceAndConverter<?> src, SourceAndConverter<?> dst) {
        SourceAndConverterHelper.transferColorConverters(new SourceAndConverter[]{src}, new SourceAndConverter[]{dst});
    }

    public static void transferColorConverters(SourceAndConverter<?>[] srcs, SourceAndConverter<?>[] dsts) {
        if (srcs != null && dsts != null) {
            for (int i = 0; i < Math.min(srcs.length, dsts.length); ++i) {
                SourceAndConverter<?> src = srcs[i];
                SourceAndConverter<?> dst = dsts[i];
                if (src == null || dst == null || !(dst.getConverter() instanceof ColorConverter) || !(src.getConverter() instanceof ColorConverter)) continue;
                ColorConverter conv_src = (ColorConverter)src.getConverter();
                ColorConverter conv_dst = (ColorConverter)dst.getConverter();
                conv_dst.setColor(conv_src.getColor());
                conv_dst.setMin(conv_src.getMin());
                conv_dst.setMax(conv_src.getMax());
                if (dst.asVolatile() == null) continue;
                conv_dst = (ColorConverter)dst.asVolatile().getConverter();
                conv_dst.setColor(conv_src.getColor());
                conv_dst.setMin(conv_src.getMin());
                conv_dst.setMax(conv_src.getMax());
            }
        }
    }

    public static int bestLevel(Source<?> src, int t, double voxSize) {
        ArrayList<Double> originVoxSize = new ArrayList<Double>();
        AffineTransform3D chainedSourceTransform = new AffineTransform3D();
        Source<?> rootOrigin = SourceAndConverterHelper.getRootSource(src, chainedSourceTransform);
        for (int l = 0; l < rootOrigin.getNumMipmapLevels(); ++l) {
            AffineTransform3D sourceTransform = new AffineTransform3D();
            rootOrigin.getSourceTransform(t, l, sourceTransform);
            double mid = SourceAndConverterHelper.getCharacteristicVoxelSize(sourceTransform.concatenate(chainedSourceTransform));
            originVoxSize.add(mid);
        }
        if (voxSize < (Double)originVoxSize.get(0)) {
            return 0;
        }
        if ((Double)originVoxSize.get(0) == 0.0) {
            System.err.println(SourceAndConverterHelper.class.getSimpleName() + " error : couldn't find voxel size of source " + src.getName());
            return 0;
        }
        double bestRatio = voxSize / (Double)originVoxSize.get(0);
        int bestLevel = 0;
        boolean doBetter = true;
        int currentLevel = 0;
        while (doBetter && currentLevel < originVoxSize.size() - 1) {
            double currentVoxSize;
            double currentRatio;
            if ((currentRatio = (currentVoxSize = ((Double)originVoxSize.get(++currentLevel)).doubleValue()) > voxSize ? currentVoxSize / voxSize : voxSize / currentVoxSize) < bestRatio) {
                bestRatio = currentRatio;
                bestLevel = currentLevel;
                continue;
            }
            doBetter = false;
        }
        return bestLevel;
    }

    public static int bestLevel(SourceAndConverter<?> sac, int t, double voxSize) {
        return SourceAndConverterHelper.bestLevel(sac.getSpimSource(), t, voxSize);
    }

    public static Source<?> getRootSource(Source<?> source, AffineTransform3D chainedSourceTransform) {
        Source<Object> rootOrigin = source;
        while (rootOrigin instanceof WarpedSource || rootOrigin instanceof TransformedSource || rootOrigin instanceof ResampledSource) {
            if (rootOrigin instanceof WarpedSource) {
                rootOrigin = ((WarpedSource)rootOrigin).getWrappedSource();
                continue;
            }
            if (rootOrigin instanceof TransformedSource) {
                AffineTransform3D m = new AffineTransform3D();
                ((TransformedSource)rootOrigin).getFixedTransform(m);
                chainedSourceTransform.concatenate(m);
                rootOrigin = ((TransformedSource)rootOrigin).getWrappedSource();
                continue;
            }
            if (!(rootOrigin instanceof ResampledSource)) continue;
            rootOrigin = ((ResampledSource)rootOrigin).getModelResamplerSource();
        }
        return rootOrigin;
    }

    public static double getCharacteristicVoxelSize(SourceAndConverter<?> sac, int t, int level) {
        return SourceAndConverterHelper.getCharacteristicVoxelSize(sac.getSpimSource(), t, level);
    }

    public static double getCharacteristicVoxelSize(Source<?> src, int t, int level) {
        AffineTransform3D chainedSourceTransform = new AffineTransform3D();
        Source<?> root = SourceAndConverterHelper.getRootSource(src, chainedSourceTransform);
        AffineTransform3D sourceTransform = new AffineTransform3D();
        root.getSourceTransform(t, level, sourceTransform);
        return SourceAndConverterHelper.getCharacteristicVoxelSize(sourceTransform.concatenate(chainedSourceTransform));
    }

    public static double getCharacteristicVoxelSize(AffineTransform3D sourceTransform) {
        double v1x = sourceTransform.get(0, 0);
        double v1y = sourceTransform.get(0, 1);
        double v1z = sourceTransform.get(0, 2);
        double v2x = sourceTransform.get(1, 0);
        double v2y = sourceTransform.get(1, 1);
        double v2z = sourceTransform.get(1, 2);
        double v3x = sourceTransform.get(2, 0);
        double v3y = sourceTransform.get(2, 1);
        double v3z = sourceTransform.get(2, 2);
        double a = Math.sqrt(v1x * v1x + v1y * v1y + v1z * v1z);
        double b = Math.sqrt(v2x * v2x + v2y * v2y + v2z * v2z);
        double c = Math.sqrt(v3x * v3x + v3y * v3y + v3z * v3z);
        return Math.max(Math.min(a, b), Math.min(Math.max(a, b), c));
    }

    public static List<SourceAndConverter<?>> getSourceAndConvertersAtCurrentMousePosition(BdvHandle bdvHandle) {
        RealPoint mousePosInBdv = new RealPoint(3);
        bdvHandle.getBdvHandle().getViewerPanel().getGlobalMouseCoordinates((RealPositionable)mousePosInBdv);
        int timePoint = bdvHandle.getViewerPanel().state().getCurrentTimepoint();
        List<SourceAndConverter<?>> sourceAndConverters = SourceAndConverterServices.getBdvDisplayService().getSourceAndConverterOf(bdvHandle).stream().filter(sac -> SourceAndConverterHelper.isSourcePresentAt(sac, timePoint, mousePosInBdv)).filter(sac -> SourceAndConverterServices.getBdvDisplayService().isVisible((SourceAndConverter<?>)sac, bdvHandle)).collect(Collectors.toList());
        return sourceAndConverters;
    }

    public static List<Double> rayIntersect(SourceAndConverter<?> sac, int timepoint, RealPoint origin, RealPoint direction) {
        if (sac.getSpimSource() == null) {
            return new ArrayList<Double>();
        }
        return SourceAndConverterHelper.rayIntersect(sac.getSpimSource(), timepoint, origin, direction);
    }

    public static List<Double> rayIntersect(Source<?> source, int timepoint, RealPoint origin, RealPoint direction) {
        if (source.isPresent(timepoint)) {
            if (source instanceof AbstractSpimSource || source instanceof TransformedSource || source instanceof ResampledSource) {
                return SourceAndConverterHelper.rayIntersectRaiSource(source, timepoint, origin, direction);
            }
            return new ArrayList<Double>();
        }
        return new ArrayList<Double>();
    }

    public static List<Double> rayIntersectRaiSource(Source<?> source, int timepoint, RealPoint origin, RealPoint direction) {
        RealPoint mainDirection;
        long nPlanes;
        long[] dims = source.getSource(timepoint, 0).dimensionsAsLongArray();
        AffineTransform3D at3d = new AffineTransform3D();
        source.getSourceTransform(timepoint, 0, at3d);
        RealPoint ui = new RealPoint(3);
        ui.setPosition(at3d.get(0, 0), 0);
        ui.setPosition(at3d.get(1, 0), 1);
        ui.setPosition(at3d.get(2, 0), 2);
        RealPoint vi = new RealPoint(3);
        vi.setPosition(at3d.get(0, 1), 0);
        vi.setPosition(at3d.get(1, 1), 1);
        vi.setPosition(at3d.get(2, 1), 2);
        RealPoint wi = new RealPoint(3);
        wi.setPosition(at3d.get(0, 2), 0);
        wi.setPosition(at3d.get(1, 2), 1);
        wi.setPosition(at3d.get(2, 2), 2);
        RealPoint oppositeCorner = new RealPoint(new float[]{dims[0] - 1L, dims[1] - 1L, dims[2] - 1L});
        at3d.apply((RealLocalizable)oppositeCorner, (RealPositionable)oppositeCorner);
        RealPoint plane0Origin = new RealPoint(new float[]{0.0f, 0.0f, 0.0f});
        at3d.apply((RealLocalizable)plane0Origin, (RealPositionable)plane0Origin);
        if (!(SourceAndConverterHelper.rayIntersectPlane(origin, direction, plane0Origin, ui, vi, dims[0], dims[1]) || SourceAndConverterHelper.rayIntersectPlane(origin, direction, plane0Origin, ui, wi, dims[0], dims[2]) || SourceAndConverterHelper.rayIntersectPlane(origin, direction, plane0Origin, vi, wi, dims[1], dims[2]) || SourceAndConverterHelper.rayIntersectPlane(origin, direction, oppositeCorner, SourceAndConverterHelper.minus3(ui), SourceAndConverterHelper.minus3(vi), dims[0], dims[1]) || SourceAndConverterHelper.rayIntersectPlane(origin, direction, oppositeCorner, SourceAndConverterHelper.minus3(ui), SourceAndConverterHelper.minus3(wi), dims[0], dims[2]) || SourceAndConverterHelper.rayIntersectPlane(origin, direction, oppositeCorner, SourceAndConverterHelper.minus3(vi), SourceAndConverterHelper.minus3(wi), dims[1], dims[2]))) {
            return new ArrayList<Double>();
        }
        RealPoint u = SourceAndConverterHelper.prodVect(vi, wi);
        RealPoint v = SourceAndConverterHelper.prodVect(ui, wi);
        RealPoint w = SourceAndConverterHelper.prodVect(ui, vi);
        SourceAndConverterHelper.normalize3(u);
        SourceAndConverterHelper.normalize3(v);
        SourceAndConverterHelper.normalize3(w);
        double absud = Math.abs(SourceAndConverterHelper.prodScal3(u, direction));
        double absvd = Math.abs(SourceAndConverterHelper.prodScal3(v, direction));
        double abswd = Math.abs(SourceAndConverterHelper.prodScal3(w, direction));
        RealPoint planeMaxOrigin = new RealPoint(new float[]{0.0f, 0.0f, 0.0f});
        if (absud > absvd) {
            if (absud > abswd) {
                nPlanes = dims[0];
                planeMaxOrigin.setPosition(nPlanes, 0);
                mainDirection = new RealPoint((RealLocalizable)u);
            } else {
                nPlanes = dims[2];
                planeMaxOrigin.setPosition(nPlanes, 2);
                mainDirection = new RealPoint((RealLocalizable)w);
            }
        } else if (absvd > abswd) {
            nPlanes = dims[1];
            planeMaxOrigin.setPosition(nPlanes, 1);
            mainDirection = new RealPoint((RealLocalizable)v);
        } else {
            nPlanes = dims[2];
            planeMaxOrigin.setPosition(nPlanes, 2);
            mainDirection = new RealPoint((RealLocalizable)w);
        }
        SourceAndConverterHelper.normalize3(mainDirection);
        at3d.apply((RealLocalizable)planeMaxOrigin, (RealPositionable)planeMaxOrigin);
        double pOrigin = SourceAndConverterHelper.prodScal3(origin, mainDirection);
        double p0 = (SourceAndConverterHelper.prodScal3(plane0Origin, mainDirection) - pOrigin) / SourceAndConverterHelper.prodScal3(direction, mainDirection);
        double pMax = (SourceAndConverterHelper.prodScal3(planeMaxOrigin, mainDirection) - pOrigin) / SourceAndConverterHelper.prodScal3(direction, mainDirection);
        if (nPlanes >= Integer.MAX_VALUE) {
            logger.debug("Too many planes");
            return new ArrayList<Double>();
        }
        ArrayList<Double> zPositions = new ArrayList<Double>((int)nPlanes);
        double step = (pMax - p0) / (double)nPlanes;
        int i = 0;
        while ((long)i < nPlanes) {
            zPositions.add(p0 + (double)i * step);
            ++i;
        }
        return zPositions;
    }

    static RealPoint minus3(RealPoint pt) {
        return new RealPoint(new double[]{-pt.getDoublePosition(0), -pt.getDoublePosition(1), -pt.getDoublePosition(2)});
    }

    public static boolean rayIntersectPlane(RealPoint rayOrigin, RealPoint rayDirection, RealPoint planeOrigin, RealPoint u, RealPoint v, double maxCoordU, double maxCoordV) {
        RealPoint uxv = SourceAndConverterHelper.prodVect(u, v);
        double denominator = SourceAndConverterHelper.prodScal3(uxv, rayDirection);
        if (Math.abs(denominator) < 1.0E-12) {
            return false;
        }
        RealPoint planeOriginMinusRayOrigin = new RealPoint(new double[]{planeOrigin.getDoublePosition(0) - rayOrigin.getDoublePosition(0), planeOrigin.getDoublePosition(1) - rayOrigin.getDoublePosition(1), planeOrigin.getDoublePosition(2) - rayOrigin.getDoublePosition(2)});
        double lambda = SourceAndConverterHelper.prodScal3(uxv, planeOriginMinusRayOrigin) / denominator;
        RealPoint ptCrossingInPlane = new RealPoint(new double[]{rayOrigin.getDoublePosition(0) + rayDirection.getDoublePosition(0) * lambda - planeOrigin.getDoublePosition(0), rayOrigin.getDoublePosition(1) + rayDirection.getDoublePosition(1) * lambda - planeOrigin.getDoublePosition(1), rayOrigin.getDoublePosition(2) + rayDirection.getDoublePosition(2) * lambda - planeOrigin.getDoublePosition(2)});
        double coordU = SourceAndConverterHelper.prodScal3(u, ptCrossingInPlane) / SourceAndConverterHelper.norm2(u);
        double coordV = SourceAndConverterHelper.prodScal3(v, ptCrossingInPlane) / SourceAndConverterHelper.norm2(v);
        return coordU > -0.5 && coordU < maxCoordU - 0.5 && coordV > -0.5 && coordV < maxCoordV - 0.5;
    }

    public static double norm2(RealPoint pt) {
        double px = pt.getDoublePosition(0);
        double py = pt.getDoublePosition(1);
        double pz = pt.getDoublePosition(2);
        return px * px + py * py + pz * pz;
    }

    public static void normalize3(RealPoint pt) {
        double px = pt.getDoublePosition(0);
        double py = pt.getDoublePosition(1);
        double pz = pt.getDoublePosition(2);
        double d = Math.sqrt(px * px + py * py + pz * pz);
        pt.setPosition(pt.getDoublePosition(0) / d, 0);
        pt.setPosition(pt.getDoublePosition(1) / d, 1);
        pt.setPosition(pt.getDoublePosition(2) / d, 2);
    }

    public static double prodScal3(RealPoint pt1, RealPoint pt2) {
        return pt1.getDoublePosition(0) * pt2.getDoublePosition(0) + pt1.getDoublePosition(1) * pt2.getDoublePosition(1) + pt1.getDoublePosition(2) * pt2.getDoublePosition(2);
    }

    public static RealPoint prodVect(RealPoint pt1, RealPoint pt2) {
        double px = pt1.getDoublePosition(1) * pt2.getDoublePosition(2) - pt1.getDoublePosition(2) * pt2.getDoublePosition(1);
        double py = pt1.getDoublePosition(2) * pt2.getDoublePosition(0) - pt1.getDoublePosition(0) * pt2.getDoublePosition(2);
        double pz = pt1.getDoublePosition(0) * pt2.getDoublePosition(1) - pt1.getDoublePosition(1) * pt2.getDoublePosition(0);
        return new RealPoint(new double[]{px, py, pz});
    }
}

