/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.services;

import bdv.viewer.SourceAndConverter;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.tree.DefaultMutableTreeNode;
import mpicbg.spim.data.generic.AbstractSpimData;
import org.scijava.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.scijava.services.ui.SourceAndConverterInspector;
import sc.fiji.bdvpg.services.SourceAndConverterAdapter;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class SourceAndConverterServiceSaver
extends SourceAndConverterAdapter
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(SourceAndConverterServiceSaver.class);
    final File f;
    List<SourceAndConverter<?>> sacs;
    final List<SourceAndConverter<?>> setOfSourcesNeedingSerialization = new ArrayList();

    public SourceAndConverterServiceSaver(File f, Context ctx) {
        this(f, ctx, SourceAndConverterServices.getSourceAndConverterService().getSourceAndConverters());
    }

    public SourceAndConverterServiceSaver(File f, Context ctx, List<SourceAndConverter<?>> sacs) {
        super(ctx, f.getParentFile(), false);
        this.sacs = sacs;
        this.f = f;
        this.idToSac = new HashMap();
        this.sacToId = new HashMap();
        this.sourceToId = new HashMap();
        this.idToSource = new HashMap();
    }

    public SourceAndConverterServiceSaver(File f, Context ctx, List<SourceAndConverter<?>> sacs, boolean useRelativePaths) {
        super(ctx, f.getParentFile(), useRelativePaths);
        this.sacs = sacs;
        this.f = f;
        this.idToSac = new HashMap();
        this.sacToId = new HashMap();
        this.sourceToId = new HashMap();
        this.idToSource = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Class<SourceAndConverterServiceSaver> clazz = SourceAndConverterServiceSaver.class;
        synchronized (SourceAndConverterServiceSaver.class) {
            this.sacs.forEach(sac -> this.setOfSourcesNeedingSerialization.addAll(SourceAndConverterInspector.appendInspectorResult(new DefaultMutableTreeNode(), sac, SourceAndConverterServices.getSourceAndConverterService(), true)));
            this.sacs = new ArrayList(this.setOfSourcesNeedingSerialization);
            this.sacs = SourceAndConverterHelper.sortDefaultGeneric(this.sacs);
            for (int i = 0; i < this.sacs.size(); ++i) {
                this.idToSac.put(i, this.sacs.get(i));
                this.sacToId.put(this.sacs.get(i), i);
                this.idToSource.put(i, this.sacs.get(i).getSpimSource());
                this.sourceToId.put(this.sacs.get(i).getSpimSource(), i);
            }
            Gson gson = this.getGson();
            Set<Object> asds = SourceAndConverterServices.getSourceAndConverterService().getSpimDatasets();
            asds = asds.stream().filter(asd -> {
                List<SourceAndConverter<?>> sacs_in_asd = SourceAndConverterServices.getSourceAndConverterService().getSourceAndConverterFromSpimdata((AbstractSpimData<?>)asd);
                return sacs_in_asd.stream().anyMatch(sac -> this.sacs.contains(sac));
            }).collect(Collectors.toSet());
            HashMap originalLocations = new HashMap();
            if (this.useRelativePaths) {
                asds.forEach(asd -> {
                    String dataLocation = (String)((SourceAndConverterService)this.getScijavaContext().getService(SourceAndConverterService.class)).getMetadata((AbstractSpimData)asd, "SPIM_DATA_LOCATION");
                    originalLocations.put(asd, dataLocation);
                    ((SourceAndConverterService)this.getScijavaContext().getService(SourceAndConverterService.class)).setMetadata((AbstractSpimData)asd, "SPIM_DATA_LOCATION", (Object)"");
                });
            }
            asds.forEach(arg_0 -> ((Gson)gson).toJson(arg_0));
            try {
                logger.info("Writing state file " + this.f.getAbsolutePath());
                FileWriter writer = new FileWriter(this.f.getAbsolutePath());
                gson.toJson(this.sacs, (Appendable)writer);
                writer.flush();
                writer.close();
                if (this.useRelativePaths) {
                    asds.forEach(asd -> ((SourceAndConverterService)this.getScijavaContext().getService(SourceAndConverterService.class)).setMetadata((AbstractSpimData)asd, "SPIM_DATA_LOCATION", originalLocations.get(asd)));
                }
            }
            catch (Exception e) {
                logger.error("Couldn't write state file: " + e.getMessage());
                e.printStackTrace();
            }
            return;
        }
    }
}

