/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.services;

import bdv.viewer.SourceAndConverter;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import org.scijava.Context;
import sc.fiji.bdvpg.services.SourceAndConverterAdapter;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class SourceAndConverterServiceLoader
extends SourceAndConverterAdapter
implements Runnable {
    final String filePath;
    final Context ctx;
    final boolean erasePreviousState;

    public SourceAndConverterServiceLoader(String filePath, String basePath, Context ctx, boolean erasePreviousState) {
        super(ctx, new File(basePath), false);
        this.filePath = filePath;
        this.idToSac = new HashMap();
        this.sacToId = new HashMap();
        this.sourceToId = new HashMap();
        this.idToSource = new HashMap();
        this.erasePreviousState = erasePreviousState;
        this.ctx = ctx;
    }

    public SourceAndConverterServiceLoader(String filePath, String basePath, Context ctx, boolean erasePreviousState, boolean useRelativePaths) {
        super(ctx, new File(basePath), useRelativePaths);
        this.filePath = filePath;
        this.idToSac = new HashMap();
        this.sacToId = new HashMap();
        this.sourceToId = new HashMap();
        this.idToSource = new HashMap();
        this.erasePreviousState = erasePreviousState;
        this.ctx = ctx;
    }

    @Override
    public void run() {
        SourceAndConverter[] sacs = SourceAndConverterServices.getSourceAndConverterService().getSourceAndConverters().toArray(new SourceAndConverter[0]);
        if (this.erasePreviousState) {
            SourceAndConverterServices.getSourceAndConverterService().remove(sacs);
        }
        try {
            FileReader fileReader = new FileReader(this.filePath);
            Gson gson = new Gson();
            JsonArray rawSacsArray = (JsonArray)gson.fromJson((Reader)fileReader, JsonArray.class);
            for (int i = 0; i < rawSacsArray.size(); ++i) {
                if (rawSacsArray.get(i).isJsonObject()) {
                    this.idToJsonElement.put(rawSacsArray.get(i).getAsJsonObject().get("source_id").getAsInt(), rawSacsArray.get(i));
                    continue;
                }
                System.err.println("Error : source " + i + " couldn't be serialized");
                System.err.println(rawSacsArray.get(i));
            }
            this.getGson().fromJson((JsonElement)rawSacsArray, SourceAndConverter[].class);
            fileReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

