/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.services;

import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import mpicbg.spim.data.generic.AbstractSpimData;
import org.scijava.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.adapter.AbstractSpimdataAdapter;
import sc.fiji.persist.ScijavaGsonHelper;

public class SourceAndConverterAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(SourceAndConverterAdapter.class);
    final File basePath;
    final boolean useRelativePaths;
    Map<Integer, SourceAndConverter<?>> idToSac;
    Map<SourceAndConverter<?>, Integer> sacToId;
    Map<Integer, Source<?>> idToSource;
    Map<Source<?>, Integer> sourceToId;
    public final Set<Integer> alreadyDeSerializedSacs = new HashSet<Integer>();
    public final Map<Integer, JsonElement> idToJsonElement = new HashMap<Integer, JsonElement>();
    final Context ctx;
    public static Consumer<String> log = arg_0 -> ((Logger)logger).debug(arg_0);

    public SourceAndConverterAdapter(Context ctx, File basePath, boolean useRelativePaths) {
        this.ctx = ctx;
        this.basePath = basePath;
        this.useRelativePaths = useRelativePaths;
    }

    public boolean useRelativePaths() {
        return this.useRelativePaths;
    }

    public File getBasePath() {
        return this.basePath;
    }

    public Context getScijavaContext() {
        return this.ctx;
    }

    public Gson getGson() {
        GsonBuilder builder = ScijavaGsonHelper.getGsonBuilder(this.ctx, true);
        builder.registerTypeHierarchyAdapter(SourceAndConverter.class, (Object)new sc.fiji.bdvpg.scijava.adapter.SourceAndConverterAdapter(this)).registerTypeHierarchyAdapter(AbstractSpimData.class, (Object)new AbstractSpimdataAdapter(this));
        return builder.create();
    }

    public synchronized Map<Integer, SourceAndConverter<?>> getIdToSac() {
        return this.idToSac;
    }

    public synchronized Map<SourceAndConverter<?>, Integer> getSacToId() {
        return this.sacToId;
    }

    public synchronized Map<Integer, Source<?>> getIdToSource() {
        return this.idToSource;
    }

    public synchronized Map<Source<?>, Integer> getSourceToId() {
        return this.sourceToId;
    }
}

