/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.widget;

import bdv.viewer.SourceAndConverter;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.scijava.services.ui.RenamableSourceAndConverter;
import sc.fiji.bdvpg.scijava.services.ui.SourceAndConverterTreeCellRenderer;
import sc.fiji.bdvpg.scijava.widget.SourceAndConverterWidget;

@Plugin(type=InputWidget.class, priority=1000000.0)
public class SwingSourceAndConverterWidget
extends SwingInputWidget<SourceAndConverter<?>>
implements SourceAndConverterWidget<JPanel> {
    @Parameter
    SourceAndConverterService bss;
    JTree tree;

    protected void doRefresh() {
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isType(SourceAndConverter.class);
    }

    public SourceAndConverter<?> getValue() {
        return this.getSelectedSourceAndConverter();
    }

    public SourceAndConverter<?> getSelectedSourceAndConverter() {
        ArrayList sacList = new ArrayList();
        for (TreePath tp : this.tree.getSelectionModel().getSelectionPaths()) {
            if (((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject() instanceof RenamableSourceAndConverter) {
                SourceAndConverter<?> userObj = ((RenamableSourceAndConverter)((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject()).sac;
                sacList.add(userObj);
                continue;
            }
            sacList.addAll(this.getSourceAndConvertersFromChildrenOf((DefaultMutableTreeNode)tp.getLastPathComponent()));
        }
        if (sacList.size() > 0) {
            return (SourceAndConverter)sacList.get(0);
        }
        return null;
    }

    private Set<SourceAndConverter<?>> getSourceAndConvertersFromChildrenOf(DefaultMutableTreeNode node) {
        HashSet sacs = new HashSet();
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.getUserObject() instanceof RenamableSourceAndConverter) {
                SourceAndConverter<?> userObj = ((RenamableSourceAndConverter)child.getUserObject()).sac;
                sacs.add(userObj);
                continue;
            }
            sacs.addAll(this.getSourceAndConvertersFromChildrenOf(child));
        }
        return sacs;
    }

    public void set(WidgetModel model) {
        super.set(model);
        this.tree = new JTreeLeavesOnlySelectable(this.bss.getUI().getTreeModel());
        this.tree.setCellRenderer(new SourceAndConverterTreeCellRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        final JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.setPreferredSize(new Dimension(350, 200));
        this.getComponent().add(scrollPane);
        this.refreshWidget();
        model.setValue(null);
        final TreeSelectionListener tsl = e -> model.setValue(this.getValue());
        this.tree.addTreeSelectionListener(tsl);
        this.tree.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                SwingSourceAndConverterWidget.this.tree.removeTreeSelectionListener(tsl);
                SwingSourceAndConverterWidget.this.tree.clearSelection();
                SwingSourceAndConverterWidget.this.tree.cancelEditing();
                SwingSourceAndConverterWidget.this.tree.resetKeyboardActions();
                SwingSourceAndConverterWidget.this.tree.updateUI();
                scrollPane.remove(SwingSourceAndConverterWidget.this.tree);
                SwingSourceAndConverterWidget.this.getComponent().remove(scrollPane);
                SwingSourceAndConverterWidget.this.tree.setModel(null);
                SwingSourceAndConverterWidget.this.tree.removeAncestorListener(this);
                SwingSourceAndConverterWidget.this.tree = null;
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    public static class JTreeLeavesOnlySelectable
    extends JTree {
        JTreeLeavesOnlySelectable(TreeModel model) {
            super(model);
        }

        @Override
        public boolean isPathSelected(TreePath path) {
            return ((DefaultMutableTreeNode)path.getLastPathComponent()).isLeaf();
        }
    }
}

