/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.widget;

import bdv.viewer.SourceAndConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.scijava.services.ui.RenamableSourceAndConverter;
import sc.fiji.bdvpg.scijava.services.ui.SourceAndConverterTreeCellRenderer;
import sc.fiji.bdvpg.scijava.services.ui.swingdnd.JListTransferHandler;
import sc.fiji.bdvpg.scijava.services.ui.swingdnd.SourceAndConverterServiceUITransferHandler;
import sc.fiji.bdvpg.scijava.widget.SourceAndConverterListWidget;

@Plugin(type=InputWidget.class)
public class SwingSourceAndConverterSortedListWidget
extends SwingInputWidget<SourceAndConverter<?>[]>
implements SourceAndConverterListWidget<JPanel> {
    @Parameter
    SourceAndConverterService bss;
    JTree tree;
    JList<RenamableSourceAndConverter> sortedSourceList;

    protected void doRefresh() {
    }

    public boolean supports(WidgetModel model) {
        return model.getItem().getWidgetStyle().contains("sorted") && super.supports(model) && model.isType(SourceAndConverter[].class);
    }

    public SourceAndConverter<?>[] getValue() {
        return this.getSelectedSourceAndConverters();
    }

    public SourceAndConverter<?>[] getSelectedSourceAndConverters() {
        int nSources = this.sortedSourceList.getModel().getSize();
        SourceAndConverter[] selection = new SourceAndConverter[nSources];
        for (int i = 0; i < nSources; ++i) {
            selection[i] = this.sortedSourceList.getModel().getElementAt((int)i).sac;
        }
        return selection;
    }

    public void set(final WidgetModel model) {
        super.set(model);
        this.getComponent().setLayout(new BorderLayout());
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.setLayout(new GridLayout(0, 2));
        this.getComponent().add((Component)innerPanel, "Center");
        this.tree = new JTree(this.bss.getUI().getTreeModel());
        this.tree.setCellRenderer(new SourceAndConverterTreeCellRenderer());
        this.tree.setDragEnabled(true);
        this.tree.setTransferHandler(new SourceAndConverterServiceUITransferHandler());
        final JScrollPane scrollPaneTree = new JScrollPane(this.tree);
        scrollPaneTree.setPreferredSize(new Dimension(350, 200));
        innerPanel.add(scrollPaneTree);
        model.setValue(null);
        this.sortedSourceList = new JList();
        this.sortedSourceList.setDropMode(DropMode.INSERT);
        this.sortedSourceList.setModel(new CustomSourceListModel());
        this.sortedSourceList.setDragEnabled(true);
        this.sortedSourceList.setTransferHandler(new JListTransferHandler());
        innerPanel.add(new JScrollPane(this.sortedSourceList));
        JLabel label = new JLabel("Drag and Drop sources from left to right");
        this.getComponent().add((Component)label, "North");
        JButton clearButton = new JButton("Clear selection");
        clearButton.addActionListener(e -> ((DefaultListModel)this.sortedSourceList.getModel()).clear());
        this.getComponent().add((Component)clearButton, "South");
        final ListDataListener ldl = new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                model.setValue(SwingSourceAndConverterSortedListWidget.this.getValue());
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                model.setValue(SwingSourceAndConverterSortedListWidget.this.getValue());
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                model.setValue(SwingSourceAndConverterSortedListWidget.this.getValue());
            }
        };
        this.sortedSourceList.getModel().addListDataListener(ldl);
        this.refreshWidget();
        this.sortedSourceList.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                SwingSourceAndConverterSortedListWidget.this.sortedSourceList.clearSelection();
                SwingSourceAndConverterSortedListWidget.this.sortedSourceList.getModel().removeListDataListener(ldl);
                DefaultListModel model = (DefaultListModel)SwingSourceAndConverterSortedListWidget.this.sortedSourceList.getModel();
                model.clear();
                SwingSourceAndConverterSortedListWidget.this.sortedSourceList.resetKeyboardActions();
                SwingSourceAndConverterSortedListWidget.this.sortedSourceList.removeAncestorListener(this);
                SwingSourceAndConverterSortedListWidget.this.sortedSourceList = null;
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.tree.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                SwingSourceAndConverterSortedListWidget.this.tree.clearSelection();
                SwingSourceAndConverterSortedListWidget.this.tree.cancelEditing();
                SwingSourceAndConverterSortedListWidget.this.tree.resetKeyboardActions();
                SwingSourceAndConverterSortedListWidget.this.tree.updateUI();
                scrollPaneTree.remove(SwingSourceAndConverterSortedListWidget.this.tree);
                SwingSourceAndConverterSortedListWidget.this.getComponent().remove(scrollPaneTree);
                SwingSourceAndConverterSortedListWidget.this.tree.setModel(null);
                SwingSourceAndConverterSortedListWidget.this.tree.removeAncestorListener(this);
                SwingSourceAndConverterSortedListWidget.this.tree = null;
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    static class CustomSourceListModel
    extends DefaultListModel {
        CustomSourceListModel() {
        }

        public void add(int index, Object element) {
            if (element instanceof SourceAndConverter) {
                super.add(index, new RenamableSourceAndConverter((SourceAndConverter)element));
            }
        }
    }
}

