/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.widget;

import bdv.viewer.SourceAndConverter;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.scijava.services.ui.RenamableSourceAndConverter;
import sc.fiji.bdvpg.scijava.services.ui.SourceAndConverterTreeCellRenderer;
import sc.fiji.bdvpg.scijava.widget.SourceAndConverterListWidget;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

@Plugin(type=InputWidget.class)
public class SwingSourceAndConverterListWidget
extends SwingInputWidget<SourceAndConverter<?>[]>
implements SourceAndConverterListWidget<JPanel> {
    @Parameter
    SourceAndConverterService bss;
    JTree tree;

    protected void doRefresh() {
    }

    public boolean supports(WidgetModel model) {
        if (model.getItem().getWidgetStyle() != null && model.getItem().getWidgetStyle().contains("sorted")) {
            return false;
        }
        return super.supports(model) && model.isType(SourceAndConverter[].class);
    }

    public SourceAndConverter<?>[] getValue() {
        return SourceAndConverterHelper.sortDefault(this.getSelectedSourceAndConverters());
    }

    public SourceAndConverter<?>[] getSelectedSourceAndConverters() {
        HashSet sacList = new HashSet();
        for (TreePath tp : this.tree.getSelectionModel().getSelectionPaths()) {
            if (((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject() instanceof RenamableSourceAndConverter) {
                SourceAndConverter<?> userObj = ((RenamableSourceAndConverter)((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject()).sac;
                sacList.add(userObj);
                continue;
            }
            sacList.addAll(this.getSourceAndConvertersFromChildrenOf((DefaultMutableTreeNode)tp.getLastPathComponent()));
        }
        return sacList.toArray(new SourceAndConverter[0]);
    }

    private Set<SourceAndConverter<?>> getSourceAndConvertersFromChildrenOf(DefaultMutableTreeNode node) {
        HashSet sacs = new HashSet();
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.getUserObject() instanceof RenamableSourceAndConverter) {
                SourceAndConverter<?> userObj = ((RenamableSourceAndConverter)child.getUserObject()).sac;
                sacs.add(userObj);
                continue;
            }
            sacs.addAll(this.getSourceAndConvertersFromChildrenOf(child));
        }
        return sacs;
    }

    public void set(WidgetModel model) {
        super.set(model);
        this.tree = new JTree(this.bss.getUI().getTreeModel());
        this.tree.setCellRenderer(new SourceAndConverterTreeCellRenderer());
        final JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.setPreferredSize(new Dimension(350, 200));
        this.getComponent().add(scrollPane);
        this.refreshWidget();
        model.setValue(null);
        final TreeSelectionListener tsl = e -> model.setValue(this.getValue());
        this.tree.addTreeSelectionListener(tsl);
        this.tree.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                SwingSourceAndConverterListWidget.this.tree.removeTreeSelectionListener(tsl);
                SwingSourceAndConverterListWidget.this.tree.clearSelection();
                SwingSourceAndConverterListWidget.this.tree.cancelEditing();
                SwingSourceAndConverterListWidget.this.tree.resetKeyboardActions();
                SwingSourceAndConverterListWidget.this.tree.updateUI();
                scrollPane.remove(SwingSourceAndConverterListWidget.this.tree);
                SwingSourceAndConverterListWidget.this.getComponent().remove(scrollPane);
                SwingSourceAndConverterListWidget.this.tree.setModel(null);
                SwingSourceAndConverterListWidget.this.tree.removeAncestorListener(this);
                SwingSourceAndConverterListWidget.this.tree = null;
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }
}

