/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.widget;

import bvv.vistools.BvvHandle;
import java.awt.Dimension;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;
import sc.fiji.bdvpg.scijava.widget.BvvHandleListWidget;
import sc.fiji.bdvpg.scijava.widget.SwingBvvHandleWidget;

@Plugin(type=InputWidget.class, priority=1000000.0)
public class SwingBvvHandleListWidget
extends SwingInputWidget<BvvHandle[]>
implements BvvHandleListWidget<JPanel> {
    JList<SwingBvvHandleWidget.RenamableBvvHandle> list;
    @Parameter
    ObjectService os;

    protected void doRefresh() {
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isType(BvvHandle[].class);
    }

    public BvvHandle[] getValue() {
        return this.getSelectedBvvHandles();
    }

    public BvvHandle[] getSelectedBvvHandles() {
        List<SwingBvvHandleWidget.RenamableBvvHandle> selected = this.list.getSelectedValuesList();
        return selected.stream().map(e -> e.bvvh).collect(Collectors.toList()).toArray(new BvvHandle[selected.size()]);
    }

    public void set(WidgetModel model) {
        super.set(model);
        SwingBvvHandleWidget.RenamableBvvHandle[] data = (SwingBvvHandleWidget.RenamableBvvHandle[])this.os.getObjects(BvvHandle.class).stream().map(SwingBvvHandleWidget.RenamableBvvHandle::new).toArray(SwingBvvHandleWidget.RenamableBvvHandle[]::new);
        this.list = new JList<SwingBvvHandleWidget.RenamableBvvHandle>(data);
        this.list.setSelectionMode(2);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(250, 80));
        this.list.addListSelectionListener(e -> model.setValue((Object)this.getValue()));
        this.getComponent().add(listScroller);
    }
}

