/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.widget;

import bdv.util.BdvHandle;
import java.awt.Dimension;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;
import sc.fiji.bdvpg.scijava.widget.BdvHandleListWidget;
import sc.fiji.bdvpg.scijava.widget.SwingBdvHandleWidget;

@Plugin(type=InputWidget.class, priority=1000000.0)
public class SwingBdvHandleListWidget
extends SwingInputWidget<BdvHandle[]>
implements BdvHandleListWidget<JPanel> {
    JList<SwingBdvHandleWidget.RenamableBdvHandle> list;
    @Parameter
    ObjectService os;

    protected void doRefresh() {
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isType(BdvHandle[].class);
    }

    public BdvHandle[] getValue() {
        return this.getSelectedBdvHandles();
    }

    public BdvHandle[] getSelectedBdvHandles() {
        List<SwingBdvHandleWidget.RenamableBdvHandle> selected = this.list.getSelectedValuesList();
        return selected.stream().map(e -> e.bdvh).collect(Collectors.toList()).toArray(new BdvHandle[selected.size()]);
    }

    public void set(WidgetModel model) {
        super.set(model);
        SwingBdvHandleWidget.RenamableBdvHandle[] data = (SwingBdvHandleWidget.RenamableBdvHandle[])this.os.getObjects(BdvHandle.class).stream().map(SwingBdvHandleWidget.RenamableBdvHandle::new).toArray(SwingBdvHandleWidget.RenamableBdvHandle[]::new);
        this.list = new JList<SwingBdvHandleWidget.RenamableBdvHandle>(data);
        this.list.setSelectionMode(2);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(250, 80));
        this.list.addListSelectionListener(e -> model.setValue((Object)this.getValue()));
        this.getComponent().add(listScroller);
    }
}

