/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.services.ui.swingdnd;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeTransferHandler
extends TransferHandler {
    protected static final Logger logger = LoggerFactory.getLogger(TreeTransferHandler.class);
    DataFlavor nodesFlavor;
    final DataFlavor[] flavors = new DataFlavor[1];

    public TreeTransferHandler() {
        try {
            String mimeType = "application/x-java-jvm-local-objectref;class=\"" + DefaultMutableTreeNode[].class.getName() + "\"";
            this.flavors[0] = this.nodesFlavor = new DataFlavor(mimeType);
        }
        catch (ClassNotFoundException e) {
            logger.error("ClassNotFound: " + e.getMessage());
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        for (DataFlavor dataFlavor : flavor) {
            for (DataFlavor value : this.flavors) {
                if (!dataFlavor.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JTree tree = (JTree)c;
        TreePath[] paths = tree.getSelectionPaths();
        if (paths != null) {
            DefaultMutableTreeNode next;
            ArrayList<DefaultMutableTreeNode> copies = new ArrayList<DefaultMutableTreeNode>();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
            DefaultMutableTreeNode copy = this.copy(node);
            copies.add(copy);
            for (int i = 1; i < paths.length && (next = (DefaultMutableTreeNode)paths[i].getLastPathComponent()).getLevel() >= node.getLevel(); ++i) {
                if (next.getLevel() > node.getLevel()) {
                    copy.add(this.copy(next));
                    continue;
                }
                copies.add(this.copy(next));
            }
            DefaultMutableTreeNode[] nodes = copies.toArray(new DefaultMutableTreeNode[0]);
            return new NodesTransferable(nodes);
        }
        return null;
    }

    private DefaultMutableTreeNode copy(TreeNode node) {
        return new DefaultMutableTreeNode(node);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        TreePath dest;
        int childIndex;
        if (!this.canImport(support)) {
            return false;
        }
        DefaultMutableTreeNode[] nodes = null;
        try {
            Transferable t = support.getTransferable();
            nodes = (DefaultMutableTreeNode[])t.getTransferData(this.nodesFlavor);
        }
        catch (UnsupportedFlavorException ufe) {
            logger.debug("UnsupportedFlavor: " + ufe.getMessage());
        }
        catch (IOException ioe) {
            logger.error("I/O error: " + ioe.getMessage());
        }
        if (support.isDrop()) {
            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
            childIndex = dl.getChildIndex();
            dest = dl.getPath();
        } else {
            childIndex = -1;
            JTree tree = (JTree)support.getComponent();
            dest = tree.getSelectionPath();
        }
        assert (dest != null);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)dest.getLastPathComponent();
        JTree tree = (JTree)support.getComponent();
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        int index = childIndex;
        if (childIndex == -1) {
            index = parent.getChildCount();
        }
        assert (nodes != null);
        for (DefaultMutableTreeNode node : nodes) {
            model.insertNodeInto(node, parent, index++);
        }
        return true;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        return this.importData(new TransferHandler.TransferSupport((Component)comp, t));
    }

    public class NodesTransferable
    implements Transferable {
        final DefaultMutableTreeNode[] nodes;

        public NodesTransferable(DefaultMutableTreeNode[] nodes) {
            this.nodes = nodes;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            if (!this.isDataFlavorSupported(flavor)) {
                return false;
            }
            return this.nodes;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return TreeTransferHandler.this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(TreeTransferHandler.this.nodesFlavor);
        }
    }
}

