/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.services.ui.swingdnd;

import bdv.ui.SourcesTransferable;
import bdv.viewer.SourceAndConverter;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.scijava.services.ui.SourceAndConverterServiceUI;
import sc.fiji.bdvpg.scijava.services.ui.SourceFilterNode;
import sc.fiji.bdvpg.scijava.services.ui.swingdnd.TreeTransferHandler;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.spimdata.importer.SpimDataFromXmlImporter;

public class SourceAndConverterServiceUITransferHandler
extends TreeTransferHandler {
    protected static final Logger logger = LoggerFactory.getLogger(SourceAndConverterServiceUITransferHandler.class);
    static DataFlavor nodesFlavor;
    static final DataFlavor[] flavors;

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    protected void exportDone(JComponent c, Transferable t, int action) {
    }

    private DefaultMutableTreeNode copy(TreeNode node) {
        if (node instanceof SourceFilterNode) {
            return (SourceFilterNode)((SourceFilterNode)node).clone();
        }
        return new DefaultMutableTreeNode(node);
    }

    protected Transferable createTransferableNodes(JComponent c) {
        JTree tree = (JTree)c;
        TreePath[] paths = tree.getSelectionPaths();
        if (paths != null) {
            DefaultMutableTreeNode next;
            ArrayList<DefaultMutableTreeNode> copies = new ArrayList<DefaultMutableTreeNode>();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
            DefaultMutableTreeNode copy = this.copy(node);
            copies.add(copy);
            for (int i = 1; i < paths.length && (next = (DefaultMutableTreeNode)paths[i].getLastPathComponent()).getLevel() >= node.getLevel(); ++i) {
                if (next.getLevel() > node.getLevel()) {
                    copy.add(this.copy(next));
                    continue;
                }
                copies.add(this.copy(next));
            }
            DefaultMutableTreeNode[] nodes = copies.toArray(new DefaultMutableTreeNode[0]);
            return new TreeTransferHandler.NodesTransferable(nodes);
        }
        return null;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        Transferable t = this.createTransferableNodes(c);
        ExtTransferable extT = new ExtTransferable();
        try {
            extT.setNodesData(t.getTransferData(nodesFlavor));
            if (SourceAndConverterServices.getSourceAndConverterService() instanceof SourceAndConverterService) {
                SourceAndConverterServiceUI ui = ((SourceAndConverterService)SourceAndConverterServices.getSourceAndConverterService()).getUI();
                ArrayList sacs = new ArrayList();
                for (SourceAndConverter sac : ui.getSelectedSourceAndConverters((JTree)c)) {
                    sacs.add(sac);
                }
                extT.setSourcesList(sacs);
            }
            return extT;
        }
        catch (UnsupportedFlavorException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport supp) {
        if (!supp.isDrop()) {
            return false;
        }
        supp.setShowDropLocation(true);
        return supp.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || supp.isDataFlavorSupported(nodesFlavor);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport supp) {
        if (!this.canImport(supp)) {
            return false;
        }
        Transferable t = supp.getTransferable();
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                for (File f : files) {
                    if (f.getAbsolutePath().endsWith(".xml")) {
                        new SpimDataFromXmlImporter(f).run();
                        continue;
                    }
                    logger.info("Unsupported drop operation with file " + f.getAbsolutePath());
                }
            } else if (t.isDataFlavorSupported(nodesFlavor)) {
                DefaultMutableTreeNode[] nodes = (DefaultMutableTreeNode[])t.getTransferData(nodesFlavor);
                if (nodes.length != 1) {
                    logger.info("Only one node should be dragged");
                    return false;
                }
                if (nodes[0] instanceof SourceFilterNode) {
                    JTree.DropLocation dl = (JTree.DropLocation)supp.getDropLocation();
                    TreePath dest = dl.getPath();
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)dest.getLastPathComponent();
                    SourceFilterNode sfn = (SourceFilterNode)nodes[0];
                    parent.add(sfn);
                    return true;
                }
                logger.debug("A source filter node should be selected");
                logger.debug("You have selected a node of class " + nodes[0].getClass().getName());
                return false;
            }
        }
        catch (UnsupportedFlavorException | IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    static {
        flavors = new DataFlavor[2];
        try {
            String mimeType = "application/x-java-jvm-local-objectref;class=\"" + DefaultMutableTreeNode[].class.getName() + "\"";
            SourceAndConverterServiceUITransferHandler.flavors[0] = nodesFlavor = new DataFlavor(mimeType);
            SourceAndConverterServiceUITransferHandler.flavors[1] = SourcesTransferable.flavor;
        }
        catch (ClassNotFoundException e) {
            logger.debug("ClassNotFound: " + e.getMessage());
        }
    }

    public static class ExtTransferable
    implements Transferable {
        Object nodes;
        SourcesTransferable sourcesTransferable;

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavors[0].equals(flavor) || flavors[1].equals(flavor);
        }

        public void setNodesData(Object nodes) {
            this.nodes = nodes;
        }

        public void setSourcesList(Collection<SourceAndConverter<?>> sources) {
            this.sourcesTransferable = new SourcesTransferable(sources);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(nodesFlavor)) {
                return this.nodes;
            }
            if (flavor.equals(SourcesTransferable.flavor)) {
                return this.sourcesTransferable.getTransferData(SourcesTransferable.flavor);
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

