/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.services.ui.swingdnd;

import bdv.ui.SourcesTransferable;
import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerPanel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.scijava.services.ui.RenamableSourceAndConverter;
import sc.fiji.bdvpg.scijava.services.ui.SourceAndConverterServiceUI;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class BdvTransferHandler
extends TransferHandler {
    protected static final Logger logger = LoggerFactory.getLogger(BdvTransferHandler.class);
    DataFlavor nodesFlavor;
    final DataFlavor[] flavors = new DataFlavor[2];
    Function<JComponent, Transferable> transferableSupplier = null;

    public BdvTransferHandler() {
        try {
            String mimeType = "application/x-java-jvm-local-objectref;class=\"" + DefaultMutableTreeNode[].class.getName() + "\"";
            this.flavors[0] = this.nodesFlavor = new DataFlavor(mimeType);
            this.flavors[1] = SourcesTransferable.flavor;
        }
        catch (ClassNotFoundException e) {
            logger.warn("ClassNotFound: " + e.getMessage());
        }
    }

    public void updateDropLocation(TransferHandler.TransferSupport support, TransferHandler.DropLocation dl) {
    }

    public void importSourcesAndConverters(TransferHandler.TransferSupport support, List<SourceAndConverter<?>> sacs) {
        Optional<BdvHandle> bdvh = this.getBdvHandleFromViewerPanel((ViewerPanel)support.getComponent());
        bdvh.ifPresent(bdvHandle -> SourceAndConverterServices.getBdvDisplayService().show((BdvHandle)bdvHandle, (SourceAndConverter<?>[])sacs.toArray(new SourceAndConverter[0])));
    }

    public Optional<BdvHandle> getBdvHandleFromViewerPanel(ViewerPanel viewerPanel) {
        return SourceAndConverterServices.getBdvDisplayService().getDisplays().stream().filter(bdvh -> bdvh.getViewerPanel().equals(viewerPanel)).findFirst();
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (support.getComponent() instanceof JComponent) {
            int n = support.getDataFlavors().length;
            for (int i = 0; i < n; ++i) {
                for (DataFlavor flavor : this.flavors) {
                    if (!support.getDataFlavors()[i].equals(flavor)) continue;
                    TransferHandler.DropLocation dl = support.getDropLocation();
                    this.updateDropLocation(support, dl);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        if (support.getTransferable().isDataFlavorSupported(SourcesTransferable.flavor)) {
            try {
                List<SourceAndConverter<?>> sacs = ((SourcesTransferable.SourceList)support.getTransferable().getTransferData(SourcesTransferable.flavor)).getSources();
                this.importSourcesAndConverters(support, sacs);
                return true;
            }
            catch (Exception sacs) {}
        } else {
            DefaultMutableTreeNode[] nodes = null;
            try {
                Transferable t = support.getTransferable();
                nodes = (DefaultMutableTreeNode[])t.getTransferData(this.nodesFlavor);
            }
            catch (UnsupportedFlavorException ufe) {
                logger.warn("UnsupportedFlavor: " + ufe.getMessage());
            }
            catch (IOException ioe) {
                logger.error("I/O error: " + ioe.getMessage());
            }
            if (nodes == null) {
                logger.warn("Null nodes found");
                return false;
            }
            if (SourceAndConverterServices.getSourceAndConverterService() instanceof SourceAndConverterService) {
                ArrayList sacs = new ArrayList();
                SourceAndConverterServiceUI ui = ((SourceAndConverterService)SourceAndConverterServices.getSourceAndConverterService()).getUI();
                for (DefaultMutableTreeNode node : nodes) {
                    DefaultMutableTreeNode unwrapped = (DefaultMutableTreeNode)node.getUserObject();
                    if (unwrapped.getUserObject() instanceof RenamableSourceAndConverter) {
                        sacs.add(((RenamableSourceAndConverter)unwrapped.getUserObject()).sac);
                        continue;
                    }
                    for (SourceAndConverter<?> sac : ui.getSourceAndConvertersFromChildrenOf(unwrapped)) {
                        sacs.add(sac);
                    }
                }
                this.importSourcesAndConverters(support, sacs);
                return true;
            }
            return false;
        }
        return false;
    }

    public void setTransferableFunction(Function<JComponent, Transferable> transferableSupplier) {
        this.transferableSupplier = transferableSupplier;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        logger.debug("Create BDV Transferable");
        if (this.transferableSupplier != null) {
            return this.transferableSupplier.apply(c);
        }
        return super.createTransferable(c);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }
}

