/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.services.ui;

import bdv.viewer.SourceAndConverter;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import sc.fiji.bdvpg.scijava.services.ui.RenamableSourceAndConverter;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class SourceFilterNode
extends DefaultMutableTreeNode
implements Cloneable {
    public Predicate<SourceAndConverter<?>> filter;
    String name;
    final boolean displayFilteredSources;
    DefaultTreeModel model;
    final Set<SourceAndConverter<?>> currentInputSacs = ConcurrentHashMap.newKeySet();
    final Set<SourceAndConverter<?>> currentOutputSacs = ConcurrentHashMap.newKeySet();

    public SourceFilterNode(DefaultTreeModel model, String name, Predicate<SourceAndConverter<?>> filter, boolean displayFilteredSources) {
        super(name);
        this.model = model;
        this.name = name;
        this.filter = filter;
        this.displayFilteredSources = displayFilteredSources;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasConsumed(SourceAndConverter<?> sac) {
        return this.currentOutputSacs.contains(sac);
    }

    @Override
    public synchronized void insert(MutableTreeNode newChild, int childIndex) {
        if (((DefaultMutableTreeNode)newChild).getUserObject() instanceof RenamableSourceAndConverter) {
            SourceAndConverter<?> sac = SourceFilterNode.getSacFromNode(newChild);
            if (!this.currentInputSacs.contains(sac)) {
                this.currentInputSacs.add(sac);
                if (this.filter.test(sac)) {
                    this.currentOutputSacs.add(sac);
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        DefaultMutableTreeNode n = (DefaultMutableTreeNode)this.getChildAt(i);
                        if (!(n instanceof SourceFilterNode)) continue;
                        n.add(new DefaultMutableTreeNode(((DefaultMutableTreeNode)newChild).getUserObject()));
                    }
                    if (this.displayFilteredSources) {
                        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(((DefaultMutableTreeNode)newChild).getUserObject());
                        super.insert(newNode, childIndex);
                        SourceFilterNode.safeModelReloadAction(() -> this.model.reload(this));
                    }
                }
            }
        } else {
            super.insert(newChild, childIndex);
            SourceFilterNode.safeModelReloadAction(() -> this.model.nodesWereInserted(this, new int[]{childIndex}));
            this.update(new NodeAddedUpdateEvent(newChild));
        }
    }

    private static SourceAndConverter<?> getSacFromNode(MutableTreeNode newChild) {
        return ((RenamableSourceAndConverter)((DefaultMutableTreeNode)newChild).getUserObject()).sac;
    }

    @Override
    public void remove(MutableTreeNode aChild) {
        int iChild = this.getIndex(aChild);
        super.remove(aChild);
        SourceFilterNode.safeModelReloadAction(() -> this.model.nodesWereRemoved(this, new int[]{iChild}, new Object[]{aChild}));
    }

    void remove(SourceAndConverter<?> sac) {
        this.currentInputSacs.remove(sac);
        this.currentOutputSacs.remove(sac);
        for (int i = 0; i < this.getChildCount(); ++i) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)this.getChildAt(i);
            if (n instanceof SourceFilterNode) {
                ((SourceFilterNode)n).remove(sac);
                continue;
            }
            if (!this.displayFilteredSources || !(n.getUserObject() instanceof RenamableSourceAndConverter) || !((RenamableSourceAndConverter)n.getUserObject()).sac.equals(sac)) continue;
            this.remove(n);
        }
    }

    public void update(UpdateEvent event) {
        Function<Collection, List> sorter = SourceAndConverterHelper::sortDefaultGeneric;
        if (event instanceof NodeAddedUpdateEvent) {
            NodeAddedUpdateEvent nodeEvent = (NodeAddedUpdateEvent)event;
            assert (this.isNodeChild(nodeEvent.getNode()));
            if (nodeEvent.getNode() instanceof SourceFilterNode) {
                for (SourceAndConverter sac : sorter.apply(this.currentOutputSacs)) {
                    ((SourceFilterNode)nodeEvent.getNode()).add(new DefaultMutableTreeNode(new RenamableSourceAndConverter(sac)));
                }
            }
        } else if (event instanceof FilterUpdateEvent) {
            for (SourceAndConverter sac : sorter.apply(this.currentInputSacs)) {
                if (this.filter.test(sac)) {
                    if (this.currentOutputSacs.contains(sac)) continue;
                    this.currentOutputSacs.add(sac);
                    RenamableSourceAndConverter rsac = new RenamableSourceAndConverter(sac);
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        DefaultMutableTreeNode n = (DefaultMutableTreeNode)this.getChildAt(i);
                        if (!(n instanceof SourceFilterNode)) continue;
                        n.add(new DefaultMutableTreeNode(rsac));
                    }
                    if (!this.displayFilteredSources) continue;
                    int iChild = this.getChildCount() - 1;
                    super.insert(new DefaultMutableTreeNode(rsac), iChild);
                    SourceFilterNode.safeModelReloadAction(() -> this.model.nodesWereInserted(this, new int[]{iChild}));
                    continue;
                }
                if (!this.currentOutputSacs.contains(sac)) continue;
                this.remove(sac);
                this.currentInputSacs.add(sac);
            }
        } else if (event instanceof SourceUpdateEvent) {
            SourceUpdateEvent sourceEvent = (SourceUpdateEvent)event;
            SourceAndConverter<?> sac = sourceEvent.getSource();
            if (this.filter.test(sac)) {
                if (!this.currentOutputSacs.contains(sac)) {
                    this.currentOutputSacs.add(sac);
                    RenamableSourceAndConverter rsac = new RenamableSourceAndConverter(sac);
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        DefaultMutableTreeNode n = (DefaultMutableTreeNode)this.getChildAt(i);
                        if (!(n instanceof SourceFilterNode)) continue;
                        n.add(new DefaultMutableTreeNode(rsac));
                    }
                    if (this.displayFilteredSources) {
                        int iChild = this.getChildCount() - 1;
                        super.insert(new DefaultMutableTreeNode(rsac), iChild);
                        SourceFilterNode.safeModelReloadAction(() -> this.model.nodesWereInserted(this, new int[]{iChild}));
                    }
                } else {
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        DefaultMutableTreeNode n = (DefaultMutableTreeNode)this.getChildAt(i);
                        if (!(n instanceof SourceFilterNode)) continue;
                        ((SourceFilterNode)n).update(event);
                    }
                }
            } else if (this.currentOutputSacs.contains(sac)) {
                this.remove(sac);
                this.currentInputSacs.add(sac);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported UpdateEvent class ");
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object clone() {
        return new SourceFilterNode(this.model, this.name, this.filter, this.displayFilteredSources);
    }

    public static void safeModelReloadAction(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static class NodeAddedUpdateEvent
    extends UpdateEvent {
        final TreeNode o;

        public NodeAddedUpdateEvent(TreeNode o) {
            this.o = o;
        }

        public TreeNode getNode() {
            return this.o;
        }
    }

    public static class SourceUpdateEvent
    extends UpdateEvent {
        final SourceAndConverter<?> sac;

        public SourceUpdateEvent(SourceAndConverter<?> sac) {
            this.sac = sac;
        }

        public SourceAndConverter<?> getSource() {
            return this.sac;
        }
    }

    public static class FilterUpdateEvent
    extends UpdateEvent {
    }

    static abstract class UpdateEvent {
        UpdateEvent() {
        }
    }
}

