/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.services.ui;

import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import sc.fiji.bdvpg.scijava.services.ui.RenamableSourceAndConverter;
import sc.fiji.bdvpg.scijava.services.ui.SourceFilterNode;

public class SourceAndConverterTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final String SPAN_FORMAT = "<span style='color:%s'>%s</span>";
    static final ImageIcon source2d;
    static final ImageIcon source3d;
    static final ImageIcon sourceFilterNode;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (this.isSourceAndConverterNode(value)) {
            this.setIcon(source3d);
            String text = String.format(SPAN_FORMAT, "rgb(80,80,80)", this.getText());
            this.setText("<html>" + text + "</html>");
            this.setToolTipText("Source node");
        } else if (value instanceof SourceFilterNode) {
            this.setIcon(sourceFilterNode);
            String text = String.format(SPAN_FORMAT, "rgb(0,0,0)", this.getText() + " [" + ((SourceFilterNode)value).currentOutputSacs.size() + "]");
            this.setText("<html>" + text + "</html>");
            this.setToolTipText("Filter node");
        }
        return this;
    }

    protected boolean isSourceAndConverterNode(Object value) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        return node.getUserObject() instanceof RenamableSourceAndConverter;
    }

    static {
        URL iconSourceURL = SourceAndConverterTreeCellRenderer.class.getResource("/images/source2d.png");
        assert (iconSourceURL != null);
        source2d = new ImageIcon(iconSourceURL);
        iconSourceURL = SourceAndConverterTreeCellRenderer.class.getResource("/images/source3d.png");
        source3d = new ImageIcon(iconSourceURL);
        iconSourceURL = SourceAndConverterTreeCellRenderer.class.getResource("/images/sourceFilterNodeCentered.png");
        assert (iconSourceURL != null);
        sourceFilterNode = new ImageIcon(iconSourceURL);
    }
}

