/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.services.ui;

import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.base.NamedEntity;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import org.scijava.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.PlaygroundPrefs;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.scijava.services.ui.BdvHandleFilterNode;
import sc.fiji.bdvpg.scijava.services.ui.RenamableSourceAndConverter;
import sc.fiji.bdvpg.scijava.services.ui.SourceAndConverterInspector;
import sc.fiji.bdvpg.scijava.services.ui.SourceAndConverterPopupMenu;
import sc.fiji.bdvpg.scijava.services.ui.SourceAndConverterTreeCellRenderer;
import sc.fiji.bdvpg.scijava.services.ui.SourceFilterNode;
import sc.fiji.bdvpg.scijava.services.ui.SpimDataElementFilter;
import sc.fiji.bdvpg.scijava.services.ui.SpimDataFilterNode;
import sc.fiji.bdvpg.scijava.services.ui.swingdnd.SourceAndConverterServiceUITransferHandler;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class SourceAndConverterServiceUI {
    protected static final Logger logger = LoggerFactory.getLogger(SourceAndConverterServiceUI.class);
    final SourceAndConverterService sourceAndConverterService;
    final JFrame frame;
    final boolean guiAvailable;
    final JTree tree;
    final SourceFilterNode top;
    private final DefaultTreeModel model;
    final List<SpimDataFilterNode> spimdataFilterNodes = new ArrayList<SpimDataFilterNode>();
    SourceFilterNode copiedNode = null;

    public SourceAndConverterServiceUI(final SourceAndConverterService sourceAndConverterService, Context context, boolean makeGUI) {
        this.sourceAndConverterService = sourceAndConverterService;
        this.top = new SourceFilterNode(null, "Sources", sac -> true, false);
        this.top.model = this.model = new DefaultTreeModel(this.top);
        this.sourceAndConverterService.registerAction("Inspect Sources", this::inspectSources);
        this.tree = new JTree(this.model);
        SourceFilterNode outsideSpimDataSources = new SourceFilterNode(this.model, "Other Sources", sac -> !sourceAndConverterService.containsMetadata((SourceAndConverter<?>)sac, "SPIMDATA"), true);
        this.top.add(outsideSpimDataSources);
        if (makeGUI) {
            this.tree.setCellRenderer(new SourceAndConverterTreeCellRenderer());
            this.frame = new JFrame("BDV Sources");
            JPanel panel = new JPanel(new BorderLayout());
            JScrollPane treeView = new JScrollPane(this.tree);
            panel.add((Component)treeView, "Center");
            this.tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    if (SwingUtilities.isRightMouseButton(e)) {
                        JPopupMenu popup = new SourceAndConverterPopupMenu(() -> SourceAndConverterServiceUI.this.getSelectedSourceAndConverters(SourceAndConverterServiceUI.this.tree)).getPopup();
                        SourceAndConverterServiceUI.this.addUISpecificActions(popup);
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.tree.setDragEnabled(true);
            this.tree.setDropMode(DropMode.ON_OR_INSERT);
            this.tree.setTransferHandler(new SourceAndConverterServiceUITransferHandler());
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int height = screenSize.height * 4 / 5;
            int width = screenSize.width / 6;
            this.frame.setPreferredSize(new Dimension(width, height));
            final JLabel cacheLabel = new JLabel("Cache");
            panel.add((Component)cacheLabel, "South");
            TimerTask periodicLogger = new TimerTask(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(() -> cacheLabel.setText(sourceAndConverterService.getCache().toString()));
                }
            };
            Timer time = new Timer();
            time.schedule(periodicLogger, 0L, 2000L);
            cacheLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        sourceAndConverterService.getCache().invalidateAll();
                        SwingUtilities.invokeLater(() -> cacheLabel.setText("Cache cleared."));
                    }
                }
            });
            this.frame.add(panel);
            this.frame.pack();
            this.frame.setVisible(false);
            this.guiAvailable = true;
        } else {
            this.guiAvailable = false;
            this.frame = null;
        }
    }

    public void show() {
        if (this.guiAvailable && PlaygroundPrefs.getSourceAndConverterUIVisibility()) {
            this.frame.setVisible(true);
        }
    }

    public void hide() {
        if (this.guiAvailable) {
            this.frame.setVisible(false);
        }
    }

    void addUISpecificActions(JPopupMenu popup) {
        JMenuItem deleteInspectNodesMenuItem = new JMenuItem("Delete Selected Inspect Nodes");
        deleteInspectNodesMenuItem.addActionListener(e -> {
            for (TreePath tp : this.tree.getSelectionModel().getSelectionPaths()) {
                if (!tp.getLastPathComponent().toString().startsWith("Inspect Results [")) continue;
                ((DefaultMutableTreeNode)tp.getLastPathComponent()).removeFromParent();
            }
        });
        JMenuItem copyFilterNodeMenuItem = new JMenuItem("Copy Filter Node");
        copyFilterNodeMenuItem.addActionListener(e -> {
            TreePath[] paths = this.tree.getSelectionModel().getSelectionPaths();
            if (paths.length != 1) {
                logger.error("Only one node should be selected");
                return;
            }
            if (paths[0].getLastPathComponent() instanceof SourceFilterNode) {
                this.copiedNode = (SourceFilterNode)((SourceFilterNode)paths[0].getLastPathComponent()).clone();
            } else {
                logger.error("A source filter node should be selected");
            }
        });
        JMenuItem pasteFilterNodeMenuItem = new JMenuItem("Paste Filter Node");
        pasteFilterNodeMenuItem.addActionListener(e -> {
            TreePath[] paths = this.tree.getSelectionModel().getSelectionPaths();
            if (paths.length != 1) {
                logger.error("Only one node should be selected");
                return;
            }
            if (paths[0].getLastPathComponent() instanceof SourceFilterNode) {
                SourceFilterNode sfn = (SourceFilterNode)paths[0].getLastPathComponent();
                sfn.add(this.copiedNode);
            } else {
                logger.error("A source filter node should be selected");
            }
        });
        JMenuItem deleteFilterNodesMenuItem = new JMenuItem("Delete Filter Node(s)");
        deleteFilterNodesMenuItem.addActionListener(e -> {
            TreePath[] paths = this.tree.getSelectionModel().getSelectionPaths();
            Stream.of(paths).map(TreePath::getLastPathComponent).filter(n -> n instanceof SourceFilterNode).forEach(n -> {
                SourceFilterNode sfn = (SourceFilterNode)n;
                if (sfn.equals(this.top)) {
                    logger.error("The root can't be deleted");
                } else {
                    sfn.removeFromParent();
                }
            });
        });
        JMenuItem addShowAllFilterNodeMenuItem = new JMenuItem("Add 'Show All' Filter Node");
        addShowAllFilterNodeMenuItem.addActionListener(e -> {
            TreePath[] paths = this.tree.getSelectionModel().getSelectionPaths();
            if (paths.length != 1) {
                logger.error("Only one node should be selected");
                return;
            }
            if (paths[0].getLastPathComponent() instanceof SourceFilterNode) {
                SourceFilterNode sfn = (SourceFilterNode)paths[0].getLastPathComponent();
                SourceFilterNode newNode = new SourceFilterNode(this.model, "All sources", sac -> true, true);
                sfn.add(newNode);
            } else {
                logger.error("A source filter node should be selected");
            }
        });
        JComponent child = popup;
        boolean found = false;
        for (int i = 0; i < popup.getComponentCount(); ++i) {
            if (!(popup.getComponent(i) instanceof JMenu) || !((JMenu)popup.getComponent(i)).getText().equals("Tree View")) continue;
            child = (JMenu)popup.getComponent(i);
            found = true;
            break;
        }
        if (!found) {
            JMenu menu = new JMenu("Tree View");
            popup.add(menu);
            child = menu;
        }
        child.add(deleteInspectNodesMenuItem);
        child.add(copyFilterNodeMenuItem);
        child.add(pasteFilterNodeMenuItem);
        child.add(addShowAllFilterNodeMenuItem);
        child.add(deleteFilterNodesMenuItem);
    }

    public void inspectSources(SourceAndConverter<?>[] sacs) {
        for (SourceAndConverter<?> sac : sacs) {
            this.inspectSource(sac);
        }
    }

    public void inspectSource(SourceAndConverter sac) {
        if (this.guiAvailable && !this.frame.isVisible()) {
            this.show();
        }
        DefaultMutableTreeNode parentNodeInspect = new DefaultMutableTreeNode("Inspect Results [" + sac.getSpimSource().getName() + "]");
        SourceAndConverterInspector.appendInspectorResult(parentNodeInspect, sac, this.sourceAndConverterService, false);
        this.top.add(parentNodeInspect);
    }

    public void removeBdvHandleNodes(BdvHandle bdvh) {
        SourceAndConverterServiceUI.visitAllNodesAndProcess(this.top, node -> {
            if (node instanceof BdvHandleFilterNode) {
                BdvHandleFilterNode bfn = (BdvHandleFilterNode)node;
                if (bfn.bdvh.equals(bdvh)) {
                    bfn.removeFromParent();
                    bfn.clear();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(SourceAndConverter sac) {
        if (this.guiAvailable && !this.frame.isVisible()) {
            this.show();
        }
        JTree jTree = this.tree;
        synchronized (jTree) {
            this.updateSpimDataFilterNodes();
            if (this.top.hasConsumed(sac)) {
                this.top.update(new SourceFilterNode.SourceUpdateEvent(sac));
            } else {
                this.top.add(new DefaultMutableTreeNode(new RenamableSourceAndConverter(sac)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSpimDataFilterNodes() {
        JTree jTree = this.tree;
        synchronized (jTree) {
            Set<AbstractSpimData<?>> currentSpimdatas = this.sourceAndConverterService.getSpimDatasets();
            HashSet obsoleteSpimDataFilterNodes = new HashSet();
            this.spimdataFilterNodes.forEach(fnode -> {
                if (!currentSpimdatas.contains(fnode.asd) && fnode.getParent() != null) {
                    obsoleteSpimDataFilterNodes.add(fnode);
                    fnode.removeFromParent();
                }
            });
            this.spimdataFilterNodes.removeAll(obsoleteSpimDataFilterNodes);
            currentSpimdatas.forEach(asd -> {
                if (this.spimdataFilterNodes.size() == 0 || this.spimdataFilterNodes.stream().noneMatch(fnode -> fnode.asd.equals(asd))) {
                    SpimDataFilterNode newNode = new SpimDataFilterNode(this.model, "SpimData " + this.spimdataFilterNodes.size(), (AbstractSpimData<?>)asd, this.sourceAndConverterService);
                    SourceFilterNode allSources = new SourceFilterNode(this.model, "All Sources", in -> true, true);
                    this.spimdataFilterNodes.add(newNode);
                    newNode.add(allSources);
                    this.top.add(newNode);
                    this.addEntityFilterNodes(newNode, (AbstractSpimData<AbstractSequenceDescription<BasicViewSetup, ?, ?>>)asd);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSpimDataName(AbstractSpimData asd_renamed, String name) {
        JTree jTree = this.tree;
        synchronized (jTree) {
            SourceAndConverterServiceUI.visitAllNodesAndProcess(this.top, node -> {
                if (node instanceof SpimDataFilterNode && ((SpimDataFilterNode)node).asd.equals((Object)asd_renamed)) {
                    ((SpimDataFilterNode)node).setName(name);
                    SourceFilterNode.safeModelReloadAction(() -> this.model.nodeChanged((TreeNode)node));
                }
            });
        }
    }

    private static void visitAllNodesAndProcess(TreeNode node, Consumer<DefaultMutableTreeNode> processor) {
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                SourceAndConverterServiceUI.visitAllNodesAndProcess(n, processor);
                if (!(n instanceof DefaultMutableTreeNode)) continue;
                processor.accept((DefaultMutableTreeNode)n);
            }
        }
    }

    private void addEntityFilterNodes(SpimDataFilterNode nodeSpimData, AbstractSpimData<AbstractSequenceDescription<BasicViewSetup, ?, ?>> asd) {
        Map entitiesByClass = asd.getSequenceDescription().getViewDescriptions().values().stream().filter(BasicViewDescription::isPresent).map(v -> v.getViewSetup().getAttributes().values()).reduce(new ArrayList(), (a, b) -> {
            a.addAll(b);
            return a;
        }).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(Object::getClass, Collectors.toList()));
        HashMap classNodes = new HashMap();
        entitiesByClass.keySet().forEach(c -> classNodes.put(c, new SourceFilterNode(this.model, c.getSimpleName(), sac -> true, false)));
        ArrayList orderedNodes = new ArrayList(classNodes.values());
        orderedNodes.sort(Comparator.comparing(SourceFilterNode::getName));
        orderedNodes.forEach(nodeSpimData::add);
        HashSet entitiesAlreadyRegistered = new HashSet();
        entitiesByClass.forEach((c, el) -> el.forEach(entity -> {
            if (!entitiesAlreadyRegistered.contains(entity)) {
                String entityName = null;
                if (entity instanceof NamedEntity) {
                    entityName = ((NamedEntity)entity).getName();
                }
                if (entityName == null || entityName.equals("")) {
                    entityName = c.getSimpleName() + " " + entity.getId();
                }
                entitiesAlreadyRegistered.add(entity);
                SpimDataElementFilter nodeElement = new SpimDataElementFilter(this.model, entityName, (Entity)entity, this.sourceAndConverterService);
                SourceFilterNode showAllSources = new SourceFilterNode(this.model, "All Sources", sac -> true, true);
                ((SourceFilterNode)classNodes.get(c)).add(nodeElement);
                nodeElement.add(showAllSources);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(SourceAndConverter sac) {
        if (this.guiAvailable && !this.frame.isVisible()) {
            this.show();
        }
        JTree jTree = this.tree;
        synchronized (jTree) {
            if (this.top.currentInputSacs.contains(sac)) {
                this.top.remove(sac);
                this.updateSpimDataFilterNodes();
            }
        }
    }

    public SourceAndConverter[] getSelectedSourceAndConverters(JTree tree) {
        HashSet sacList = new HashSet();
        for (TreePath tp : tree.getSelectionModel().getSelectionPaths()) {
            if (((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject() instanceof RenamableSourceAndConverter) {
                SourceAndConverter<?> userObj = ((RenamableSourceAndConverter)((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject()).sac;
                sacList.add(userObj);
                continue;
            }
            sacList.addAll(this.getSourceAndConvertersFromChildrenOf((DefaultMutableTreeNode)tp.getLastPathComponent()));
        }
        return SourceAndConverterHelper.sortDefaultGeneric(sacList).toArray(new SourceAndConverter[0]);
    }

    public Set<SourceAndConverter<?>> getSourceAndConvertersFromChildrenOf(DefaultMutableTreeNode node) {
        HashSet sacs = new HashSet();
        if (node.getUserObject() instanceof RenamableSourceAndConverter) {
            SourceAndConverter<?> userObj = ((RenamableSourceAndConverter)node.getUserObject()).sac;
            sacs.add(userObj);
        } else if (node instanceof SourceFilterNode) {
            sacs.addAll(((SourceFilterNode)node).currentOutputSacs);
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                if (child instanceof SourceFilterNode) {
                    sacs.addAll(((SourceFilterNode)child).currentOutputSacs);
                    continue;
                }
                if (child.getUserObject() instanceof RenamableSourceAndConverter) {
                    SourceAndConverter<?> userObj = ((RenamableSourceAndConverter)child.getUserObject()).sac;
                    sacs.add(userObj);
                    continue;
                }
                sacs.addAll(this.getSourceAndConvertersFromChildrenOf(child));
            }
        }
        return sacs;
    }

    public DefaultTreeModel getTreeModel() {
        return this.model;
    }

    public TreePath getTreePathFromString(String path) {
        String[] stringPath = path.split(">");
        Object[] nodes = new Object[stringPath.length];
        TreeNode current = this.top;
        int currentDepth = 0;
        while (currentDepth < stringPath.length) {
            Enumeration<? extends TreeNode> children = current.children();
            boolean found = false;
            while (children.hasMoreElements()) {
                TreeNode testNode = children.nextElement();
                if (testNode.toString().trim().equals(stringPath[currentDepth].trim())) {
                    nodes[currentDepth] = testNode;
                    ++currentDepth;
                    current = testNode;
                    found = true;
                    break;
                }
                logger.error("Unmatched " + testNode.toString().trim());
            }
            if (found) continue;
            break;
        }
        if (currentDepth == stringPath.length) {
            return new TreePath(nodes);
        }
        return null;
    }

    public List<SourceAndConverter<?>> getSourceAndConvertersFromTreePath(TreePath path) {
        return SourceAndConverterHelper.sortDefaultGeneric(this.getSourceAndConvertersFromChildrenOf((DefaultMutableTreeNode)path.getLastPathComponent()));
    }

    public List<SourceAndConverter<?>> getSourceAndConvertersFromPath(String path) {
        TreePath tp = this.getTreePathFromString(path);
        if (tp != null) {
            return this.getSourceAndConvertersFromTreePath(tp);
        }
        return new ArrayList();
    }

    public synchronized void addNode(DefaultMutableTreeNode node) {
        this.top.add(node);
    }

    public synchronized void removeNode(DefaultMutableTreeNode node) {
        this.getTreeModel().removeNodeFromParent(node);
    }

    public synchronized void addNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode node) {
        parent.add(node);
    }

    public Node getRoot() {
        return new Node((TreeNode)this.model.getRoot());
    }

    public static class Node {
        private final TreeNode node;

        protected Node(TreeNode node) {
            this.node = node;
        }

        public Node child(int index) {
            return new Node(this.node.getChildAt(index));
        }

        public Node child(String name) {
            Enumeration<? extends TreeNode> children = this.node.children();
            while (children.hasMoreElements()) {
                TreeNode testNode = children.nextElement();
                if (!testNode.toString().equals(name)) continue;
                return new Node(testNode);
            }
            return null;
        }

        public List<Node> children() {
            ArrayList<Node> list = new ArrayList<Node>(this.node.getChildCount());
            Enumeration<? extends TreeNode> children = this.node.children();
            while (children.hasMoreElements()) {
                TreeNode n = children.nextElement();
                list.add(new Node(n));
            }
            return list;
        }

        public String name() {
            return this.node.toString();
        }

        public String toString() {
            return this.name();
        }

        public String path() {
            String fullPath = this.name();
            for (Node parent = this.parent(); parent != null; parent = parent.parent()) {
                fullPath = this.parent().name() + ">" + fullPath;
            }
            return fullPath;
        }

        public SourceAndConverter<?>[] sources() {
            if (this.node instanceof SourceFilterNode) {
                Set<SourceAndConverter<?>> sourcesSet = ((SourceFilterNode)this.node).currentOutputSacs;
                return SourceAndConverterHelper.sortDefault(sourcesSet.toArray(new SourceAndConverter[0]));
            }
            if (this.node instanceof RenamableSourceAndConverter) {
                return new SourceAndConverter[]{((RenamableSourceAndConverter)((Object)this.node)).sac};
            }
            return null;
        }

        public Node parent() {
            if (this.node.getParent() == null) {
                return null;
            }
            return new Node(this.node.getParent());
        }
    }
}

