/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.services.ui;

import bdv.viewer.SourceAndConverter;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import sc.fiji.bdvpg.bdv.config.BdvSettingsGUISetter;
import sc.fiji.bdvpg.scijava.command.bdv.BdvSourcesAdderCommand;
import sc.fiji.bdvpg.scijava.command.bdv.BdvSourcesRemoverCommand;
import sc.fiji.bdvpg.scijava.command.bdv.BdvSourcesShowCommand;
import sc.fiji.bdvpg.scijava.command.source.BasicTransformerCommand;
import sc.fiji.bdvpg.scijava.command.source.ColorSourceCreatorCommand;
import sc.fiji.bdvpg.scijava.command.source.InteractiveBrightnessAdjusterCommand;
import sc.fiji.bdvpg.scijava.command.source.LUTSourceCreatorCommand;
import sc.fiji.bdvpg.scijava.command.source.MakeMetadataFilterNodeCommand;
import sc.fiji.bdvpg.scijava.command.source.ManualTransformCommand;
import sc.fiji.bdvpg.scijava.command.source.SourceColorChangerCommand;
import sc.fiji.bdvpg.scijava.command.source.SourcesDuplicatorCommand;
import sc.fiji.bdvpg.scijava.command.source.SourcesInvisibleMakerCommand;
import sc.fiji.bdvpg.scijava.command.source.SourcesRemoverCommand;
import sc.fiji.bdvpg.scijava.command.source.SourcesResamplerCommand;
import sc.fiji.bdvpg.scijava.command.source.SourcesVisibleMakerCommand;
import sc.fiji.bdvpg.scijava.command.source.TransformedSourceWrapperCommand;
import sc.fiji.bdvpg.scijava.command.source.XmlHDF5ExporterCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class SourceAndConverterPopupMenu {
    private JPopupMenu popup;
    private final Supplier<SourceAndConverter<?>[]> sacs_supplier;
    public static final String[] defaultPopupActions = new String[]{SourceAndConverterService.getCommandName(BdvSourcesAdderCommand.class), SourceAndConverterService.getCommandName(BdvSourcesShowCommand.class), SourceAndConverterService.getCommandName(BdvSourcesRemoverCommand.class), "Inspect Sources", "PopupLine", SourceAndConverterService.getCommandName(SourcesInvisibleMakerCommand.class), SourceAndConverterService.getCommandName(SourcesVisibleMakerCommand.class), SourceAndConverterService.getCommandName(InteractiveBrightnessAdjusterCommand.class), SourceAndConverterService.getCommandName(SourceColorChangerCommand.class), "PopupLine", SourceAndConverterService.getCommandName(BasicTransformerCommand.class), SourceAndConverterService.getCommandName(SourcesDuplicatorCommand.class), SourceAndConverterService.getCommandName(ManualTransformCommand.class), SourceAndConverterService.getCommandName(TransformedSourceWrapperCommand.class), SourceAndConverterService.getCommandName(SourcesResamplerCommand.class), SourceAndConverterService.getCommandName(ColorSourceCreatorCommand.class), SourceAndConverterService.getCommandName(LUTSourceCreatorCommand.class), "PopupLine", SourceAndConverterService.getCommandName(SourcesRemoverCommand.class), SourceAndConverterService.getCommandName(XmlHDF5ExporterCommand.class), "PopupLine", SourceAndConverterService.getCommandName(MakeMetadataFilterNodeCommand.class)};
    String[] popupActionWithPaths;
    final DefaultMutableTreeNode menuRoot;

    public SourceAndConverterPopupMenu(Supplier<SourceAndConverter<?>[]> sacs_supplier, String path, String context) {
        this.sacs_supplier = sacs_supplier;
        this.popupActionWithPaths = defaultPopupActions;
        File f = BdvSettingsGUISetter.getActionFile(path, context);
        if (f.exists()) {
            try {
                Gson gson = new Gson();
                this.popupActionWithPaths = (String[])gson.fromJson((Reader)new FileReader(f.getAbsoluteFile()), String[].class);
                if (this.popupActionWithPaths == null || this.popupActionWithPaths.length == 0) {
                    this.popupActionWithPaths = new String[]{"Warning: Empty " + f.getAbsolutePath() + " config file."};
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            File fdefault = new File(f.getAbsolutePath() + ".default.txt");
            if (fdefault.exists()) {
                try {
                    Gson gson = new Gson();
                    this.popupActionWithPaths = (String[])gson.fromJson((Reader)new FileReader(fdefault.getAbsoluteFile()), String[].class);
                    if (this.popupActionWithPaths == null || this.popupActionWithPaths.length == 0) {
                        this.popupActionWithPaths = new String[]{"Warning: Empty " + fdefault.getAbsolutePath() + " config file."};
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                System.err.println("Bdv Playground actions settings File " + f.getAbsolutePath() + " does not exist.");
                System.err.println("Bdv Playground default actions settings File " + fdefault.getAbsolutePath() + " does not exist.");
            }
        }
        this.popup = new JPopupMenu();
        this.menuRoot = new DefaultMutableTreeNode(this.popup);
        this.createPopupMenu();
    }

    public SourceAndConverterPopupMenu(Supplier<SourceAndConverter<?>[]> sacs_supplier) {
        this(sacs_supplier, "", "tree");
    }

    public SourceAndConverterPopupMenu(Supplier<SourceAndConverter<?>[]> sacs_supplier, String[] actionWithPaths) {
        this.sacs_supplier = sacs_supplier;
        this.popupActionWithPaths = actionWithPaths;
        this.popup = new JPopupMenu();
        this.menuRoot = new DefaultMutableTreeNode(this.popup);
        this.createPopupMenu();
    }

    private void createPopupMenu() {
        for (String actionNameWithPath : this.popupActionWithPaths) {
            String[] path = actionNameWithPath.split(">");
            String actionName = path[path.length - 1];
            if (actionName.equals("PopupLine")) {
                this.addPopupLine(path);
                continue;
            }
            this.addPopupAction(actionNameWithPath, SourceAndConverterServices.getSourceAndConverterService().getAction(actionName.trim()));
        }
    }

    public void addPopupLine(String[] path) {
        JComponent component = this.getNodeFromPath(path);
        if (component instanceof JPopupMenu) {
            ((JPopupMenu)component).addSeparator();
        } else if (component instanceof JMenu) {
            ((JMenu)component).addSeparator();
        } else {
            System.err.println("Unexpected menu class: " + component.getClass().getSimpleName());
        }
    }

    public void addPopupAction(String actionNameWithPath, Consumer<SourceAndConverter<?>[]> action) {
        String[] pathsAndAction = actionNameWithPath.split(">");
        String actionName = pathsAndAction[pathsAndAction.length - 1];
        JMenuItem menuItem = new JMenuItem(actionName);
        if (action != null) {
            menuItem.addActionListener(e -> action.accept(this.sacs_supplier.get()));
        } else {
            menuItem.addActionListener(e -> System.err.println("No action defined for action named " + actionName));
        }
        this.getNodeFromPath(pathsAndAction).add(menuItem);
    }

    private JComponent getNodeFromPath(String[] pathsAndAction) {
        DefaultMutableTreeNode currentNode = this.menuRoot;
        for (int idx = 0; idx < pathsAndAction.length - 1; ++idx) {
            String currentPath = pathsAndAction[idx];
            Enumeration<TreeNode> en = currentNode.depthFirstEnumeration();
            boolean found = false;
            while (en.hasMoreElements()) {
                JMenu menuEntry;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
                if (!(node.getUserObject() instanceof JMenu) || !(menuEntry = (JMenu)node.getUserObject()).getText().equals(currentPath)) continue;
                currentNode = node;
                found = true;
                break;
            }
            if (found) continue;
            JMenu entry = new JMenu(currentPath);
            if (currentNode.getUserObject() instanceof JMenu) {
                ((JMenu)currentNode.getUserObject()).add(entry);
            } else if (currentNode.getUserObject() instanceof JPopupMenu) {
                ((JPopupMenu)currentNode.getUserObject()).add(entry);
            } else {
                System.err.println("Unexpected menu class: " + currentNode.getUserObject().getClass().getSimpleName());
            }
            DefaultMutableTreeNode newEntry = new DefaultMutableTreeNode(entry);
            currentNode.add(newEntry);
            currentNode = newEntry;
        }
        return (JComponent)currentNode.getUserObject();
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }
}

