/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.services.ui;

import bdv.AbstractSpimSource;
import bdv.img.WarpedSource;
import bdv.tools.transformation.TransformedSource;
import bdv.util.ResampledSource;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.tree.DefaultMutableTreeNode;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.scijava.services.ui.RenamableSourceAndConverter;
import sc.fiji.bdvpg.services.ISourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class SourceAndConverterInspector {
    protected static final Logger logger = LoggerFactory.getLogger(SourceAndConverterInspector.class);

    public static void appendMetadata(DefaultMutableTreeNode parent, SourceAndConverter<?> sac) {
        SourceAndConverterServices.getSourceAndConverterService().getMetadataKeys(sac).forEach(k -> {
            DefaultMutableTreeNode nodeMetaKey = new DefaultMutableTreeNode(k);
            parent.add(nodeMetaKey);
            DefaultMutableTreeNode nodeMetaValue = new DefaultMutableTreeNode(SourceAndConverterServices.getSourceAndConverterService().getMetadata(sac, (String)k));
            nodeMetaKey.add(nodeMetaValue);
        });
    }

    public static Set<SourceAndConverter<?>> appendInspectorResult(DefaultMutableTreeNode parent, SourceAndConverter<?> sac, ISourceAndConverterService sourceAndConverterService, boolean registerIntermediateSources) {
        DefaultMutableTreeNode wrappedSourceNode;
        SourceAndConverter src2;
        Source source;
        HashSet subSources = new HashSet();
        subSources.add(sac);
        if (sac.getSpimSource() instanceof TransformedSource) {
            DefaultMutableTreeNode nodeTransformedSource = new DefaultMutableTreeNode("Transformed Source");
            parent.add(nodeTransformedSource);
            source = (TransformedSource)sac.getSpimSource();
            if (sourceAndConverterService.getSourceAndConvertersFromSource(((TransformedSource)source).getWrappedSource()).size() > 0) {
                sourceAndConverterService.getSourceAndConvertersFromSource(((TransformedSource)source).getWrappedSource()).forEach(src -> {
                    DefaultMutableTreeNode wrappedSourceNode = new DefaultMutableTreeNode(new RenamableSourceAndConverter((SourceAndConverter<?>)src));
                    nodeTransformedSource.add(wrappedSourceNode);
                    subSources.addAll(SourceAndConverterInspector.appendInspectorResult(wrappedSourceNode, src, sourceAndConverterService, registerIntermediateSources));
                });
            } else {
                src2 = SourceAndConverterHelper.createSourceAndConverter(((TransformedSource)source).getWrappedSource());
                if (registerIntermediateSources) {
                    sourceAndConverterService.register(src2);
                }
                wrappedSourceNode = new DefaultMutableTreeNode(new RenamableSourceAndConverter(src2));
                nodeTransformedSource.add(wrappedSourceNode);
                subSources.addAll(SourceAndConverterInspector.appendInspectorResult(wrappedSourceNode, src2, sourceAndConverterService, registerIntermediateSources));
            }
            DefaultMutableTreeNode nodeAffineTransformGetter = new DefaultMutableTreeNode(new Supplier<AffineTransform3D>(){

                @Override
                public AffineTransform3D get() {
                    AffineTransform3D at3D = new AffineTransform3D();
                    source.getFixedTransform(at3D);
                    return at3D;
                }

                public String toString() {
                    return "AffineTransform[" + source.getName() + "]";
                }
            });
            nodeTransformedSource.add(nodeAffineTransformGetter);
            SourceAndConverterInspector.appendMetadata(nodeTransformedSource, sac);
        }
        if (sac.getSpimSource() instanceof WarpedSource) {
            DefaultMutableTreeNode nodeWarpedSource = new DefaultMutableTreeNode("Warped Source");
            parent.add(nodeWarpedSource);
            source = (WarpedSource)sac.getSpimSource();
            if (sourceAndConverterService.getSourceAndConvertersFromSource(source.getWrappedSource()).size() > 0) {
                sourceAndConverterService.getSourceAndConvertersFromSource(source.getWrappedSource()).forEach(src -> {
                    DefaultMutableTreeNode wrappedSourceNode = new DefaultMutableTreeNode(new RenamableSourceAndConverter((SourceAndConverter<?>)src));
                    nodeWarpedSource.add(wrappedSourceNode);
                    subSources.addAll(SourceAndConverterInspector.appendInspectorResult(wrappedSourceNode, src, sourceAndConverterService, registerIntermediateSources));
                });
            } else {
                src2 = SourceAndConverterHelper.createSourceAndConverter(source.getWrappedSource());
                if (registerIntermediateSources) {
                    sourceAndConverterService.register(src2);
                }
                wrappedSourceNode = new DefaultMutableTreeNode(new RenamableSourceAndConverter(src2));
                nodeWarpedSource.add(wrappedSourceNode);
                subSources.addAll(SourceAndConverterInspector.appendInspectorResult(wrappedSourceNode, src2, sourceAndConverterService, registerIntermediateSources));
            }
            DefaultMutableTreeNode nodeRealTransformGetter = new DefaultMutableTreeNode(new Supplier<RealTransform>(){

                @Override
                public RealTransform get() {
                    return source.getTransform();
                }

                public String toString() {
                    return "RealTransform[" + source.getName() + "]";
                }
            });
            nodeWarpedSource.add(nodeRealTransformGetter);
            SourceAndConverterInspector.appendMetadata(nodeWarpedSource, sac);
        }
        if (sac.getSpimSource() instanceof ResampledSource) {
            DefaultMutableTreeNode nodeResampledSource = new DefaultMutableTreeNode("Resampled Source");
            parent.add(nodeResampledSource);
            source = (ResampledSource)sac.getSpimSource();
            DefaultMutableTreeNode nodeOrigin = new DefaultMutableTreeNode("Origin");
            nodeResampledSource.add(nodeOrigin);
            if (sourceAndConverterService.getSourceAndConvertersFromSource(((ResampledSource)source).getOriginalSource()).size() > 0) {
                sourceAndConverterService.getSourceAndConvertersFromSource(((ResampledSource)source).getOriginalSource()).forEach(src -> {
                    DefaultMutableTreeNode wrappedSourceNode = new DefaultMutableTreeNode(new RenamableSourceAndConverter((SourceAndConverter<?>)src));
                    nodeOrigin.add(wrappedSourceNode);
                    subSources.addAll(SourceAndConverterInspector.appendInspectorResult(wrappedSourceNode, src, sourceAndConverterService, registerIntermediateSources));
                });
            } else {
                SourceAndConverter<?> src3 = SourceAndConverterHelper.createSourceAndConverter(((ResampledSource)source).getOriginalSource());
                if (registerIntermediateSources) {
                    sourceAndConverterService.register(src3);
                }
                DefaultMutableTreeNode wrappedSourceNode2 = new DefaultMutableTreeNode(new RenamableSourceAndConverter(src3));
                nodeOrigin.add(wrappedSourceNode2);
                subSources.addAll(SourceAndConverterInspector.appendInspectorResult(wrappedSourceNode2, src3, sourceAndConverterService, registerIntermediateSources));
            }
            DefaultMutableTreeNode nodeResampler = new DefaultMutableTreeNode("Sampler Model");
            nodeResampledSource.add(nodeResampler);
            if (sourceAndConverterService.getSourceAndConvertersFromSource(((ResampledSource)source).getModelResamplerSource()).size() > 0) {
                sourceAndConverterService.getSourceAndConvertersFromSource(((ResampledSource)source).getModelResamplerSource()).forEach(src -> {
                    DefaultMutableTreeNode wrappedSourceNode = new DefaultMutableTreeNode(new RenamableSourceAndConverter((SourceAndConverter<?>)src));
                    nodeResampler.add(wrappedSourceNode);
                    subSources.addAll(SourceAndConverterInspector.appendInspectorResult(wrappedSourceNode, src, sourceAndConverterService, registerIntermediateSources));
                });
            } else {
                SourceAndConverter<?> src4 = SourceAndConverterHelper.createSourceAndConverter(((ResampledSource)source).getModelResamplerSource());
                if (registerIntermediateSources) {
                    sourceAndConverterService.register(src4);
                }
                DefaultMutableTreeNode wrappedSourceNode3 = new DefaultMutableTreeNode(new RenamableSourceAndConverter(src4));
                nodeResampler.add(wrappedSourceNode3);
                subSources.addAll(SourceAndConverterInspector.appendInspectorResult(wrappedSourceNode3, src4, sourceAndConverterService, registerIntermediateSources));
            }
            SourceAndConverterInspector.appendMetadata(nodeResampledSource, sac);
        }
        if (sac.getSpimSource() instanceof AbstractSpimSource) {
            DefaultMutableTreeNode nodeSpimSource = new DefaultMutableTreeNode("Spim Source");
            parent.add(nodeSpimSource);
            SourceAndConverterInspector.appendMetadata(nodeSpimSource, sac);
        }
        return subSources;
    }

    public static SourceAndConverter<?> getRootSourceAndConverter(SourceAndConverter<?> sac, SourceAndConverterService sacService) {
        return SourceAndConverterInspector.getListToRootSourceAndConverter(sac, sacService).getLast();
    }

    public static SourceAndConverter<?> getRootSourceAndConverter(SourceAndConverter<?> sac) {
        return SourceAndConverterInspector.getListToRootSourceAndConverter(sac, (SourceAndConverterService)SourceAndConverterServices.getSourceAndConverterService()).getLast();
    }

    public static SourceAndConverter<?> getRootSourceAndConverter(Source<?> source) {
        List<SourceAndConverter<?>> sacs = SourceAndConverterServices.getSourceAndConverterService().getSourceAndConvertersFromSource(source);
        SourceAndConverter<?> sac = sacs.size() == 0 ? SourceAndConverterHelper.createSourceAndConverter(source) : sacs.get(0);
        return SourceAndConverterInspector.getListToRootSourceAndConverter(sac, (SourceAndConverterService)SourceAndConverterServices.getSourceAndConverterService()).getLast();
    }

    public static LinkedList<SourceAndConverter<?>> getListToRootSourceAndConverter(SourceAndConverter<?> sac, SourceAndConverterService sacService) {
        LinkedList chain = new LinkedList();
        DefaultMutableTreeNode nodeSac = new DefaultMutableTreeNode(new RenamableSourceAndConverter(sac));
        chain.add(sac);
        SourceAndConverterInspector.appendInspectorResult(nodeSac, sac, sacService, false);
        DefaultMutableTreeNode current = nodeSac;
        while (current.getChildCount() > 0) {
            if ((current = (DefaultMutableTreeNode)current.getFirstChild()).getUserObject() instanceof RenamableSourceAndConverter) {
                chain.add(((RenamableSourceAndConverter)current.getUserObject()).sac);
                continue;
            }
            logger.debug("No renamable source found");
            logger.debug("RenamableSourceAndConverter not contained in first node of inspector result");
            logger.debug("Class found = " + current.getUserObject().getClass().getSimpleName());
            logger.debug("Object found = " + current.getUserObject());
        }
        return chain;
    }
}

