/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.services.ui;

import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerStateChangeListener;
import javax.swing.tree.DefaultTreeModel;
import sc.fiji.bdvpg.scijava.services.ui.SourceFilterNode;

public class BdvHandleFilterNode
extends SourceFilterNode {
    public final BdvHandle bdvh;
    final String name;
    final ViewerStateChangeListener vscl;

    public boolean filter(SourceAndConverter<?> sac) {
        return this.bdvh.getViewerPanel().state().getSources().contains(sac);
    }

    public BdvHandleFilterNode(DefaultTreeModel model, String name, BdvHandle bdvh) {
        super(model, name, null, false);
        this.name = name;
        this.filter = this::filter;
        this.bdvh = bdvh;
        this.vscl = change -> {
            if (change.toString().equals("NUM_SOURCES_CHANGED")) {
                this.update(new SourceFilterNode.FilterUpdateEvent());
            }
        };
        bdvh.getViewerPanel().state().changeListeners().add((Object)this.vscl);
    }

    public void clear() {
        this.bdvh.getViewerPanel().state().changeListeners().remove((Object)this.vscl);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public Object clone() {
        return new BdvHandleFilterNode(this.model, this.name, this.bdvh);
    }
}

