/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.services;

import bdv.SpimSource;
import bdv.ViewerImgLoader;
import bdv.VolatileSpimSource;
import bdv.img.cache.VolatileGlobalCellCache;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.n5.N5ImageLoader;
import bdv.spimdata.WrapBasicImgLoader;
import bdv.tools.brightness.ConverterSetup;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicMultiResolutionSetupImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import net.imagej.patcher.LegacyInjector;
import net.imglib2.converter.Converter;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;
import org.scijava.InstantiableException;
import org.scijava.command.Command;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandService;
import org.scijava.module.ModuleItem;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginService;
import org.scijava.prefs.PrefService;
import org.scijava.script.ScriptService;
import org.scijava.service.AbstractService;
import org.scijava.service.SciJavaService;
import org.scijava.service.Service;
import org.scijava.ui.UIService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.cache.AbstractGlobalCache;
import sc.fiji.bdvpg.cache.GlobalCacheBuilder;
import sc.fiji.bdvpg.cache.GlobalLoaderCache;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;
import sc.fiji.bdvpg.scijava.services.ui.SourceAndConverterServiceUI;
import sc.fiji.bdvpg.services.ISourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.spimdata.EntityHandler;
import sc.fiji.bdvpg.spimdata.IEntityHandlerService;

@Plugin(type=Service.class, headless=true)
public class SourceAndConverterService
extends AbstractService
implements SciJavaService,
ISourceAndConverterService {
    protected static final Logger logger = LoggerFactory.getLogger(SourceAndConverterService.class);
    @Parameter
    ObjectService objectService;
    @Parameter
    PrefService prefService;
    @Parameter
    ScriptService scriptService;
    @Parameter
    CommandService commandService;
    @Parameter
    IEntityHandlerService entityHandlerService;
    SourceAndConverterBdvDisplayService bsds = null;
    Cache<SourceAndConverter<?>, Map<String, Object>> sacToMetadata;
    public static String UNIQUE_ID_KEY;
    AtomicInteger sourceCounter = new AtomicInteger(0);
    private AbstractGlobalCache globalCache;
    SourceAndConverterServiceUI ui;
    final Map<String, Consumer<SourceAndConverter<?>[]>> actionMap = new ConcurrentHashMap<String, Consumer<SourceAndConverter<?>[]>>();
    Cache<AbstractSpimData, Map<String, Object>> spimdataToMetadata;

    @Override
    public boolean isRegistered(SourceAndConverter<?> src) {
        return this.sacToMetadata.getIfPresent(src) != null;
    }

    public void setDisplayService(SourceAndConverterBdvDisplayService bsds) {
        this.bsds = bsds;
    }

    @Override
    public void setMetadata(SourceAndConverter<?> sac, String key, Object data) {
        if (sac == null) {
            logger.error("Error : sac is null in setMetadata function! ");
            return;
        }
        if (this.sacToMetadata.getIfPresent(sac) == null) {
            logger.error("Error : sac has no associated metadata ! This should not happen. ");
            logger.error("Sac : " + sac.getSpimSource().getName());
            logger.error("SpimSource class: " + sac.getSpimSource().getClass().getSimpleName());
        } else {
            ((Map)this.sacToMetadata.getIfPresent(sac)).put(key, data);
        }
    }

    @Override
    public Object getMetadata(SourceAndConverter<?> sac, String key) {
        Map meta = (Map)this.sacToMetadata.getIfPresent(sac);
        if (meta != null) {
            return meta.get(key);
        }
        return null;
    }

    @Override
    public void removeMetadata(SourceAndConverter<?> sac, String key) {
        Map metadata = (Map)this.sacToMetadata.getIfPresent(sac);
        if (metadata != null) {
            metadata.remove(key);
        }
    }

    @Override
    public Collection<String> getMetadataKeys(SourceAndConverter<?> sac) {
        Map map = (Map)this.sacToMetadata.getIfPresent(sac);
        if (map == null) {
            return new ArrayList<String>();
        }
        return map.keySet();
    }

    @Override
    public boolean containsMetadata(SourceAndConverter<?> sac, String key) {
        return this.getMetadata(sac, key) != null;
    }

    @Override
    public void register(SourceAndConverter<?> sac) {
        this.register(sac, true);
    }

    private synchronized void register(SourceAndConverter<?> sac, boolean treeView) {
        if (this.objectService.getObjects(SourceAndConverter.class).contains(sac)) {
            logger.debug("Source already registered");
            return;
        }
        if (this.sacToMetadata.getIfPresent(sac) == null) {
            HashMap<String, Integer> sourceData = new HashMap<String, Integer>();
            sourceData.put(UNIQUE_ID_KEY, this.getNewUniqueId());
            this.sacToMetadata.put(sac, sourceData);
        }
        this.objectService.addObject(sac);
        if (treeView) {
            this.ui.update(sac);
        }
    }

    @Override
    public void register(SourceAndConverter<?> src, String ... options) {
        for (String option : options) {
            if (!option.equals("no tree")) continue;
            this.register(src, false);
        }
        this.register(src);
    }

    public int getNewUniqueId() {
        return this.sourceCounter.incrementAndGet();
    }

    public int getUniqueId(SourceAndConverter<?> sac) {
        return (Integer)this.getMetadata(sac, UNIQUE_ID_KEY);
    }

    public void setUniqueId(SourceAndConverter<?> sac, Integer id) {
        this.setMetadata(sac, UNIQUE_ID_KEY, (Object)id);
    }

    public synchronized void register(Collection<SourceAndConverter<?>> sources) {
        for (SourceAndConverter<?> sac : sources) {
            this.register(sac);
        }
    }

    @Override
    public AbstractGlobalCache getCache() {
        return this.globalCache;
    }

    private boolean replaceSpimDataCacheByGlobalCache(AbstractSpimData<?> asd) {
        GlobalLoaderCache loaderCache = new GlobalLoaderCache(asd);
        BasicImgLoader imageLoader = asd.getSequenceDescription().getImgLoader();
        VolatileGlobalCellCache cache = new VolatileGlobalCellCache(10, Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
        try {
            Field backingCacheField = VolatileGlobalCellCache.class.getDeclaredField("backingCache");
            backingCacheField.setAccessible(true);
            backingCacheField.set(cache, loaderCache);
            if (imageLoader instanceof Hdf5ImageLoader) {
                Field cacheField = Hdf5ImageLoader.class.getDeclaredField("cache");
                cacheField.setAccessible(true);
                cacheField.set(imageLoader, cache);
                return true;
            }
            if (imageLoader instanceof N5ImageLoader) {
                Field cacheField = N5ImageLoader.class.getDeclaredField("cache");
                cacheField.setAccessible(true);
                cacheField.set(imageLoader, cache);
                return true;
            }
            Field cacheField = imageLoader.getClass().getDeclaredField("cache");
            cacheField.setAccessible(true);
            cacheField.set(imageLoader, cache);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public synchronized void register(AbstractSpimData<?> asd) {
        if (this.spimdataToMetadata.getIfPresent(asd) == null) {
            HashMap sourceData = new HashMap();
            this.spimdataToMetadata.put(asd, sourceData);
        }
        HashMap entityClassToHandler = new HashMap();
        this.entityHandlerService.getHandlers(EntityHandler.class).forEach(pi -> {
            try {
                EntityHandler handler = (EntityHandler)pi.createInstance();
                entityClassToHandler.put(handler.getEntityType(), handler);
                logger.debug("Plugin found for entity class " + handler.getEntityType().getSimpleName());
            }
            catch (InstantiableException e) {
                e.printStackTrace();
            }
        });
        boolean nonVolatile = WrapBasicImgLoader.wrapImgLoaderIfNecessary(asd);
        if (nonVolatile) {
            logger.warn("WARNING:\nOpening <SpimData> dataset that is not suited for interactive browsing.\nConsider resaving as HDF5 for better performance.");
        }
        AbstractSequenceDescription seq = asd.getSequenceDescription();
        ViewerImgLoader imgLoader = (ViewerImgLoader)seq.getImgLoader();
        HashMap setupIdToSourceAndConverter = new HashMap();
        for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
            entityClassToHandler.keySet().forEach(entityClass -> {
                Entity e = setup.getAttribute(entityClass);
                if (e != null) {
                    ((EntityHandler)entityClassToHandler.get(entityClass)).loadEntity(asd, setup);
                }
            });
            int setupId = setup.getId();
            BasicMultiResolutionSetupImgLoader vsil = imgLoader.getSetupImgLoader(setupId);
            String sourceName = SourceAndConverterService.createSetupName(setup);
            Object type = vsil.getImageType();
            entityClassToHandler.keySet().forEach(entityClass -> {
                Entity e = setup.getAttribute(entityClass);
                if (e != null && ((EntityHandler)entityClassToHandler.get(entityClass)).canCreateSourceAndConverter()) {
                    setupIdToSourceAndConverter.put(setupId, ((EntityHandler)entityClassToHandler.get(entityClass)).makeSourceAndConverter(asd, setup));
                }
            });
            if (!setupIdToSourceAndConverter.containsKey(setupId)) {
                Object volatileConverter;
                if (type instanceof RealType) {
                    SpimSource s = new SpimSource(asd, setupId, sourceName);
                    Converter<RealType, ARGBType> nonVolatileConverter = SourceAndConverterHelper.createConverterRealType((RealType)s.getType());
                    if (!nonVolatile) {
                        VolatileSpimSource vs = new VolatileSpimSource(asd, setupId, sourceName);
                        volatileConverter = SourceAndConverterHelper.createConverterRealType((RealType)vs.getType());
                        setupIdToSourceAndConverter.put(setupId, new SourceAndConverter<RealType>(s, nonVolatileConverter, new SourceAndConverter(vs, volatileConverter)));
                    } else {
                        setupIdToSourceAndConverter.put(setupId, new SourceAndConverter<RealType>(s, nonVolatileConverter));
                    }
                } else if (type instanceof ARGBType) {
                    VolatileSpimSource vs = new VolatileSpimSource(asd, setupId, sourceName);
                    SpimSource s = new SpimSource(asd, setupId, sourceName);
                    Converter<?, ARGBType> nonVolatileConverter = SourceAndConverterHelper.createConverterARGBType(s);
                    volatileConverter = SourceAndConverterHelper.createConverterARGBType(vs);
                    setupIdToSourceAndConverter.put(setupId, new SourceAndConverter(s, nonVolatileConverter, new SourceAndConverter(vs, volatileConverter)));
                } else {
                    logger.error("Cannot open Spimdata with Source of type " + type.getClass().getSimpleName());
                }
            }
            entityClassToHandler.keySet().forEach(entityClass -> {
                Entity e = setup.getAttribute(entityClass);
                if (e != null) {
                    ((EntityHandler)entityClassToHandler.get(entityClass)).loadEntity(asd, setup, (SourceAndConverter)setupIdToSourceAndConverter.get(setupId));
                }
            });
        }
        setupIdToSourceAndConverter.keySet().forEach(id -> {
            this.register((SourceAndConverter)setupIdToSourceAndConverter.get(id));
            this.linkToSpimData((SourceAndConverter)setupIdToSourceAndConverter.get(id), (AbstractSpimData)asd, (int)id);
            this.ui.update((SourceAndConverter)setupIdToSourceAndConverter.get(id));
        });
        WrapBasicImgLoader.removeWrapperIfPresent(asd);
        boolean success = this.replaceSpimDataCacheByGlobalCache(asd);
        if (!success) {
            logger.warn("Could not link abstract spimdata cache to Bdv Playground global cache");
        } else {
            logger.info("Spimdata " + asd + " is using the Bdv Playground global cache.");
        }
    }

    @Override
    public void register(AbstractSpimData<?> asd, String ... options) {
        this.register(asd);
    }

    private static String createSetupName(BasicViewSetup setup) {
        Channel channel;
        if (setup.hasName() && !setup.getName().trim().equals("")) {
            return setup.getName();
        }
        String name = "";
        Angle angle = (Angle)setup.getAttribute(Angle.class);
        if (angle != null) {
            name = name + "a " + angle.getName();
        }
        if ((channel = (Channel)setup.getAttribute(Channel.class)) != null) {
            name = name + (name.isEmpty() ? "" : " ") + "c " + channel.getName();
        }
        if (channel == null && angle == null) {
            name = name + "id " + setup.getId();
        }
        return name;
    }

    @Override
    public ConverterSetup getConverterSetup(SourceAndConverter<?> sac) {
        Map meta;
        if (!this.isRegistered(sac)) {
            this.register(sac);
        }
        if ((meta = (Map)this.sacToMetadata.getIfPresent(sac)) == null) {
            logger.error("getConverterSetup NPE : the source " + sac.getSpimSource().getName() + " has no metadata associated! ");
            return null;
        }
        if (meta.get("ConverterSetup") == null) {
            ConverterSetup setup = SourceAndConverterHelper.createConverterSetup(sac);
            meta.put("ConverterSetup", setup);
        }
        return (ConverterSetup)meta.get("ConverterSetup");
    }

    @Override
    public synchronized void remove(SourceAndConverter<?> ... sacs) {
        if (sacs != null) {
            if (this.bsds != null) {
                this.bsds.removeFromAllBdvs(sacs);
            }
            for (SourceAndConverter<?> sac : sacs) {
                AbstractSpimData asd = null;
                Map meta = (Map)this.sacToMetadata.getIfPresent(sac);
                if (meta != null) {
                    if (meta.get("SPIMDATA") != null) {
                        asd = ((SpimDataInfo)meta.get((Object)"SPIMDATA")).asd;
                    }
                    if (asd != null && this.getSourceAndConverterFromSpimdata(asd).size() == 1) {
                        ViewerImgLoader imgLoader;
                        if (asd.getSequenceDescription().getImgLoader() instanceof ViewerImgLoader && (imgLoader = (ViewerImgLoader)asd.getSequenceDescription().getImgLoader()).getCacheControl() instanceof VolatileGlobalCellCache) {
                            ((VolatileGlobalCellCache)imgLoader.getCacheControl()).clearCache();
                        }
                        if (asd.getSequenceDescription().getImgLoader() instanceof Closeable) {
                            try {
                                ((Closeable)asd.getSequenceDescription().getImgLoader()).close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        this.spimdataToMetadata.invalidate((Object)asd);
                    }
                    this.sacToMetadata.invalidate(sac);
                } else {
                    logger.error(sac.getSpimSource().getName() + " has no associated metadata");
                }
                this.objectService.removeObject(sac);
                this.ui.remove(sac);
            }
        }
    }

    @Override
    public List<SourceAndConverter<?>> getSourceAndConverters() {
        List list = this.objectService.getObjects(SourceAndConverter.class);
        List<SourceAndConverter<?>> nonRawList = new ArrayList();
        list.forEach(nonRawList::add);
        nonRawList = SourceAndConverterHelper.sortDefaultGeneric(nonRawList);
        return nonRawList;
    }

    @Override
    public List<SourceAndConverter<?>> getSourceAndConverterFromSpimdata(AbstractSpimData<?> asd) {
        List<SourceAndConverter> rawList = this.objectService.getObjects(SourceAndConverter.class).stream().filter(s -> ((Map)this.sacToMetadata.getIfPresent(s)).get("SPIMDATA") != null).filter(s -> ((SpimDataInfo)((Map)this.sacToMetadata.getIfPresent((Object)s)).get((Object)"SPIMDATA")).asd.equals(asd)).collect(Collectors.toList());
        ArrayList list = new ArrayList();
        rawList.forEach(list::add);
        return list;
    }

    public void linkToSpimData(SourceAndConverter sac, AbstractSpimData asd, int idSetup) {
        ((Map)this.sacToMetadata.getIfPresent((Object)sac)).put("SPIMDATA", new SpimDataInfo(asd, idSetup));
    }

    public SourceAndConverterServiceUI getUI() {
        return this.ui;
    }

    public void initialize() {
        this.scriptService.addAlias(SourceAndConverter.class);
        this.scriptService.addAlias(RealTransform.class);
        this.scriptService.addAlias(AffineTransform3D.class);
        this.scriptService.addAlias(AbstractSpimData.class);
        this.sacToMetadata = CacheBuilder.newBuilder().weakKeys().build();
        this.spimdataToMetadata = CacheBuilder.newBuilder().weakKeys().build();
        this.registerDefaultActions();
        logger.info(" --- Setting global cache ");
        Gson gson = new Gson();
        String defaultCacheBuilder = gson.toJson((Object)GlobalCacheBuilder.builder(), GlobalCacheBuilder.class);
        String cacheBuilderJson = this.prefService.get(this.getClass(), "cache.builder", defaultCacheBuilder);
        try {
            this.globalCache = ((GlobalCacheBuilder)gson.fromJson(cacheBuilderJson, GlobalCacheBuilder.class)).create();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("Restoring default cache builder");
            String cacheBuilderSerialized = gson.toJson((Object)GlobalCacheBuilder.builder(), GlobalCacheBuilder.class);
            logger.debug("Cache builder serialized into : " + cacheBuilderSerialized);
            this.prefService.put(this.getClass(), "cache.builder", cacheBuilderSerialized);
            this.globalCache = GlobalCacheBuilder.builder().create();
        }
        if (this.context().getService(UIService.class) != null) {
            if (!((UIService)this.context().getService(UIService.class)).isHeadless()) {
                logger.debug("GUI detected : Constructing JFrame for BdvSourceAndConverterService");
                this.ui = new SourceAndConverterServiceUI(this, this.context(), true);
            } else {
                this.ui = new SourceAndConverterServiceUI(this, this.context(), false);
            }
        }
        SourceAndConverterServices.setSourceAndConverterService(this);
        logger.debug("Service initialized.");
    }

    public List<SourceAndConverter<?>> getSourceAndConvertersFromSource(Source src) {
        return this.getSourceAndConverters().stream().filter(sac -> sac.getSpimSource().equals(src)).collect(Collectors.toList());
    }

    @Override
    public void registerAction(String actionName, Consumer<SourceAndConverter<?>[]> action) {
        if (this.actionMap.containsKey(actionName)) {
            logger.warn("Overriding action " + actionName);
        }
        this.actionMap.put(actionName, action);
    }

    @Override
    public void removeAction(String actionName) {
        this.actionMap.remove(actionName);
    }

    @Override
    public Consumer<SourceAndConverter<?>[]> getAction(String actionName) {
        return this.actionMap.get(actionName);
    }

    @Override
    public Set<AbstractSpimData<?>> getSpimDatasets() {
        HashSet asds = new HashSet();
        this.getSourceAndConverters().forEach(sac -> {
            if (this.containsMetadata((SourceAndConverter<?>)sac, "SPIMDATA")) {
                asds.add(((SpimDataInfo)this.getMetadata(sac, (String)"SPIMDATA")).asd);
            }
        });
        return asds;
    }

    @Override
    public Set<String> getActionsKeys() {
        return this.actionMap.keySet();
    }

    public static String getCommandName(Class<? extends Command> c) {
        String menuPath = c.getDeclaredAnnotation(Plugin.class).menuPath();
        return menuPath.substring(menuPath.lastIndexOf(">") + 1);
    }

    void registerDefaultActions() {
        this.registerAction("Display names", srcs -> {
            for (SourceAndConverter src : srcs) {
                logger.debug(src.getSpimSource().getName());
            }
        });
        ((PluginService)this.context().getService(PluginService.class)).getPluginsOfType(BdvPlaygroundActionCommand.class).forEach(ci -> this.registerScijavaCommandInfo(this.commandService.getCommand(ci.getClassName())));
    }

    public void registerScijavaCommandInfo(CommandInfo ci) {
        int nCountSourceAndConverter = 0;
        int nCountSourceAndConverterList = 0;
        try {
            for (ModuleItem input : ci.inputs()) {
                if (input.getType().equals(SourceAndConverter.class)) {
                    ++nCountSourceAndConverter;
                }
                if (!input.getType().equals(SourceAndConverter[].class)) continue;
                ++nCountSourceAndConverterList;
            }
            if (nCountSourceAndConverter + nCountSourceAndConverterList == 1) {
                for (ModuleItem input : ci.inputs()) {
                    if (input.getType().equals(SourceAndConverter.class)) {
                        this.registerAction(ci.getMenuPath().getLeaf().toString(), sacs -> {
                            for (SourceAndConverter sac : sacs) {
                                this.commandService.run(ci, true, new Object[]{input.getName(), sac});
                            }
                        });
                        logger.debug("Registering action entitled " + ci.getMenuPath().getLeaf().toString() + " from command " + ci.getClassName());
                    }
                    if (!input.getType().equals(SourceAndConverter[].class)) continue;
                    this.registerAction(ci.getMenuPath().getLeaf().toString(), sacs -> this.commandService.run(ci, true, new Object[]{input.getName(), sacs}));
                    logger.debug("Registering action entitled " + ci.getMenuPath().getLeaf().toString() + " from command " + ci.getClassName());
                }
            } else {
                this.registerAction(ci.getMenuPath().getLeaf().toString(), sacs -> this.commandService.run(ci, true, new Object[0]));
                logger.debug("Registering action entitled " + ci.getMenuPath().getMenuString() + " from command " + ci.getClassName() + " sacs ignored");
            }
        }
        catch (NullPointerException npe) {
            logger.error("Error on scijava commands registrations");
            logger.error("Null Pointer Exception for command '" + ci.getTitle() + "'");
            logger.error("Try to exclude this command by modifying ActionPackages.json file");
            logger.error("class : " + ci.getClassName());
        }
        catch (Exception e) {
            logger.error("Error on scijava commands registrations");
            logger.error("Exception for command " + ci.getTitle());
            logger.error("Try to exclude this command by modifying ActionPackages.json file");
            logger.error("class : " + ci.getClassName());
            e.printStackTrace();
        }
    }

    public void registerScijavaCommand(Class<? extends Command> commandClass) {
        this.registerScijavaCommandInfo(this.commandService.getCommand(commandClass));
    }

    public synchronized void setSpimDataName(AbstractSpimData asd, String name) {
        ((Map)this.spimdataToMetadata.getIfPresent((Object)asd)).put("NAME", name);
        this.ui.updateSpimDataName(asd, name);
    }

    public void setMetadata(AbstractSpimData asd, String key, Object data) {
        if (asd == null) {
            logger.error("Error : asd is null in setMetadata function! ");
            return;
        }
        if (this.spimdataToMetadata.getIfPresent((Object)asd) == null) {
            HashMap sourceData = new HashMap();
            this.spimdataToMetadata.put((Object)asd, sourceData);
        }
        ((Map)this.spimdataToMetadata.getIfPresent((Object)asd)).put(key, data);
    }

    public Object getMetadata(AbstractSpimData asd, String key) {
        if (this.spimdataToMetadata.getIfPresent((Object)asd) != null) {
            return ((Map)this.spimdataToMetadata.getIfPresent((Object)asd)).get(key);
        }
        return null;
    }

    public Collection<String> getMetadataKeys(AbstractSpimData asd) {
        Map map = (Map)this.spimdataToMetadata.getIfPresent((Object)asd);
        if (map == null) {
            return new ArrayList<String>();
        }
        return map.keySet();
    }

    public boolean containsMetadata(AbstractSpimData asd, String key) {
        return this.getMetadata(asd, key) != null;
    }

    public static String getCommandName(Command command) {
        return command.getClass().getAnnotation(Plugin.class).name();
    }

    static {
        LegacyInjector.preinit();
        UNIQUE_ID_KEY = "Unique_ID";
    }

    public static class SpimDataInfo {
        public final AbstractSpimData asd;
        public final int setupId;

        public SpimDataInfo(AbstractSpimData asd, int setupId) {
            this.asd = asd;
            this.setupId = setupId;
        }

        public String toString() {
            return this.asd.toString() + ": setupId = " + this.setupId;
        }
    }
}

