/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.services;

import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SynchronizedViewerState;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import ij.Prefs;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.tree.DefaultTreeModel;
import net.imglib2.converter.Converter;
import net.imglib2.util.Pair;
import org.scijava.Context;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.script.ScriptService;
import org.scijava.service.AbstractService;
import org.scijava.service.SciJavaService;
import org.scijava.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.bdv.supplier.DefaultBdvSupplier;
import sc.fiji.bdvpg.bdv.supplier.IBdvSupplier;
import sc.fiji.bdvpg.bdv.supplier.SerializableBdvOptions;
import sc.fiji.bdvpg.scijava.services.GuavaWeakCacheService;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.scijava.services.ui.BdvHandleFilterNode;
import sc.fiji.bdvpg.scijava.services.ui.SourceFilterNode;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.persist.ScijavaGsonHelper;

@Plugin(type=Service.class)
public class SourceAndConverterBdvDisplayService
extends AbstractService
implements SciJavaService {
    protected static final Logger logger = LoggerFactory.getLogger(SourceAndConverterBdvDisplayService.class);
    public static final String CONVERTER_SETUP = "ConverterSetup";
    @Parameter
    ScriptService scriptService;
    @Parameter
    SourceAndConverterService bdvSourceAndConverterService;
    @Parameter
    GuavaWeakCacheService cacheService;
    @Parameter
    ObjectService os;
    @Parameter
    Context ctx;
    Supplier<BdvHandle> bdvSupplier;
    final List<Pair<BdvHandle, BdvHandle>> pairedBdvs = new ArrayList<Pair<BdvHandle, BdvHandle>>();
    Cache<BdvHandle, Map<String, Object>> displayToMetadata;

    public void setDefaultBdvSupplier(IBdvSupplier bdvSupplier) {
        this.bdvSupplier = bdvSupplier;
        logger.info(" --- Serializing to save default bdv window of class " + bdvSupplier.getClass().getSimpleName());
        Gson gson = ScijavaGsonHelper.getGson(this.ctx, true);
        String bdvSupplierSerialized = gson.toJson((Object)bdvSupplier, IBdvSupplier.class);
        logger.info("Bdv Supplier serialized into : " + bdvSupplierSerialized);
        Prefs.set((String)"bigdataviewer.playground.supplier", (String)bdvSupplierSerialized);
    }

    public BdvHandle getNewBdv() {
        if (this.bdvSupplier == null) {
            logger.debug(" --- Fetching or generating default bdv window");
            Gson gson = ScijavaGsonHelper.getGson(this.ctx);
            String defaultBdvViewer = gson.toJson((Object)new DefaultBdvSupplier(new SerializableBdvOptions()), IBdvSupplier.class);
            String bdvSupplierJson = Prefs.get((String)"bigdataviewer.playground.supplier", (String)defaultBdvViewer);
            try {
                this.bdvSupplier = (Supplier)gson.fromJson(bdvSupplierJson, IBdvSupplier.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("Restoring default bdv supplier");
                this.bdvSupplier = new DefaultBdvSupplier(new SerializableBdvOptions());
                String bdvSupplierSerialized = gson.toJson(this.bdvSupplier, IBdvSupplier.class);
                logger.debug("Bdv Supplier serialized into : " + bdvSupplierSerialized);
                Prefs.set((String)"bigdataviewer.playground.supplier", (String)bdvSupplierSerialized);
            }
        }
        BdvHandle bdvh = this.bdvSupplier.get();
        this.registerBdvHandle(bdvh);
        return bdvh;
    }

    public BdvHandle getActiveBdv() {
        List bdvhs = this.os.getObjects(BdvHandle.class);
        if (bdvhs == null || bdvhs.size() == 0) {
            return this.getNewBdv();
        }
        if (bdvhs.size() == 1) {
            return (BdvHandle)bdvhs.get(0);
        }
        Optional<BdvHandle> bdvh = bdvhs.stream().filter(b -> b.getViewerPanel().hasFocus()).findFirst();
        if (bdvh.isPresent()) {
            return bdvh.get();
        }
        if (this.cacheService.get("LAST_ACTIVE_BDVH") != null) {
            WeakReference wr_bdv_h = (WeakReference)this.cacheService.get("LAST_ACTIVE_BDVH");
            return (BdvHandle)wr_bdv_h.get();
        }
        return null;
    }

    public void show(SourceAndConverter<?> ... sacs) {
        this.show(this.getActiveBdv(), sacs);
    }

    public void setVisible(SourceAndConverter<?> sac, boolean visible) {
        this.getDisplaysOf(sac).forEach(bdvhr -> bdvhr.getViewerPanel().state().setSourceActive(sac, visible));
    }

    public boolean isVisible(SourceAndConverter<?> sac, BdvHandle bdvh) {
        return bdvh.getViewerPanel().state().isSourceActive(sac);
    }

    public void show(BdvHandle bdvh, SourceAndConverter<?> ... sacs) {
        this.show(bdvh, true, sacs);
    }

    public void show(BdvHandle bdvh, boolean visible, SourceAndConverter<?> ... sacs) {
        ArrayList sacsToDisplay = new ArrayList();
        for (SourceAndConverter<?> sac : sacs) {
            if (!this.bdvSourceAndConverterService.isRegistered(sac)) {
                this.bdvSourceAndConverterService.register(sac);
            }
            boolean escape = false;
            if (bdvh.getViewerPanel().state().getSources().contains(sac)) {
                escape = true;
            }
            if (sacsToDisplay.contains(sac)) {
                escape = true;
            }
            if (escape) continue;
            sacsToDisplay.add(sac);
            bdvh.getConverterSetups().put(sac, this.bdvSourceAndConverterService.getConverterSetup(sac));
        }
        bdvh.getViewerPanel().state().addSources(sacsToDisplay);
        bdvh.getViewerPanel().state().setSourcesActive(sacsToDisplay, visible);
    }

    public void removeFromAllBdvs(SourceAndConverter<?> ... sacs) {
        this.getDisplaysOf(sacs).forEach(bdv -> bdv.getViewerPanel().state().removeSources(Arrays.asList(sacs)));
    }

    public void removeFromActiveBdv(SourceAndConverter<?> ... sacs) {
        if (this.os.getObjects(BdvHandle.class).size() > 0) {
            this.remove(this.getActiveBdv(), sacs);
        }
    }

    public void remove(BdvHandle bdvh, SourceAndConverter<?> ... sacs) {
        bdvh.getViewerPanel().state().removeSources(Arrays.asList(sacs));
        bdvh.getViewerPanel().requestRepaint();
    }

    public void updateConverter(SourceAndConverter<?> source, Converter<?, ?> cvt) {
        logger.error("Unsupported operation : a new SourceAndConverterObject should be built. (TODO) ");
    }

    public void initialize() {
        this.scriptService.addAlias(BdvHandle.class);
        this.displayToMetadata = CacheBuilder.newBuilder().weakKeys().build();
        this.bdvSourceAndConverterService.setDisplayService(this);
        SourceAndConverterServices.setBdvDisplayService(this);
        logger.debug("Bdv Playground Display Service initialized.");
    }

    public void closeBdv(BdvHandle bdvh) {
        this.os.removeObject((Object)bdvh);
        this.displayToMetadata.invalidate((Object)bdvh);
        boolean isPaired = this.pairedBdvs.stream().anyMatch(p -> p.getA() == bdvh || p.getB() == bdvh);
        if (isPaired) {
            Pair pair = this.pairedBdvs.stream().filter(p -> p.getA() == bdvh || p.getB() == bdvh).findFirst().get();
            this.pairedBdvs.remove(pair);
            if (pair.getA() == bdvh) {
                this.closeBdv((BdvHandle)pair.getB());
            } else {
                this.closeBdv((BdvHandle)pair.getA());
            }
        }
    }

    public void pairClosing(final BdvHandle bdv1, final BdvHandle bdv2) {
        this.pairedBdvs.add(new Pair<BdvHandle, BdvHandle>(){

            public BdvHandle getA() {
                return bdv1;
            }

            public BdvHandle getB() {
                return bdv2;
            }
        });
    }

    public void registerBdvSource(BdvHandle bdvh_in) {
        bdvh_in.getViewerPanel().state().getSources().forEach(sac -> {
            if (!this.bdvSourceAndConverterService.isRegistered((SourceAndConverter<?>)sac)) {
                this.bdvSourceAndConverterService.register((SourceAndConverter<?>)sac);
            }
        });
    }

    public void updateDisplays(SourceAndConverter<?> ... sacs) {
        this.getDisplaysOf(sacs).forEach(bdvHandle -> bdvHandle.getViewerPanel().requestRepaint());
    }

    public List<SourceAndConverter<?>> getSourceAndConverterOf(BdvHandle bdvHandle) {
        return bdvHandle.getViewerPanel().state().getSources();
    }

    public Set<BdvHandle> getDisplaysOf(SourceAndConverter<?> ... sacs) {
        if (sacs == null) {
            return new HashSet<BdvHandle>();
        }
        List<SourceAndConverter<?>> sacList = Arrays.asList(sacs);
        return this.os.getObjects(BdvHandle.class).stream().filter(bdv -> {
            SynchronizedViewerState synchronizedViewerState = bdv.getViewerPanel().state();
            synchronized (synchronizedViewerState) {
                return bdv.getViewerPanel().state().getSources().stream().anyMatch(sacList::contains);
            }
        }).collect(Collectors.toSet());
    }

    public List<BdvHandle> getDisplays() {
        return this.os.getObjects(BdvHandle.class);
    }

    public void setDisplayMetadata(BdvHandle bdvh, String key, Object data) {
        if (bdvh == null) {
            logger.error("Error : bdvh is null in setMetadata function! ");
            return;
        }
        if (this.displayToMetadata.getIfPresent((Object)bdvh) == null) {
            this.displayToMetadata.put((Object)bdvh, new HashMap());
        }
        ((Map)this.displayToMetadata.getIfPresent((Object)bdvh)).put(key, data);
    }

    public Object getDisplayMetadata(BdvHandle bdvh, String key) {
        if (this.displayToMetadata.getIfPresent((Object)bdvh) != null) {
            return ((Map)this.displayToMetadata.getIfPresent((Object)bdvh)).get(key);
        }
        return null;
    }

    public void registerBdvHandle(BdvHandle bdvh) {
        if (!this.os.getObjects(BdvHandle.class).contains(bdvh)) {
            this.os.addObject((Object)bdvh);
            String windowTitle = BdvHandleHelper.getWindowTitle(bdvh);
            windowTitle = BdvHandleHelper.getUniqueWindowTitle(this.os, windowTitle);
            BdvHandleHelper.setWindowTitle(bdvh, windowTitle);
            SourceAndConverterService sacService = (SourceAndConverterService)SourceAndConverterServices.getSourceAndConverterService();
            DefaultTreeModel model = sacService.getUI().getTreeModel();
            BdvHandleFilterNode node = new BdvHandleFilterNode(model, windowTitle, bdvh);
            node.add(new SourceFilterNode(model, "All Sources", sac -> true, true));
            BdvHandleHelper.setBdvHandleCloseOperation(bdvh, this.cacheService, this, true, () -> sacService.getUI().removeBdvHandleNodes(bdvh));
            ((SourceFilterNode)sacService.getUI().getTreeModel().getRoot()).insert(node, 0);
        }
    }
}

