/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.services;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.scijava.cache.CacheService;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class GuavaWeakCacheService
extends AbstractService
implements CacheService {
    private Cache<Object, Object> cache;

    public Cache<Object, Object> getCache() {
        return this.cache;
    }

    public void logCache(Consumer<String> logger) {
        this.cache.asMap().forEach((key, value) -> {
            logger.accept(key.getClass().getSimpleName() + ":" + key);
            logger.accept("\t" + value.getClass().getSimpleName() + ":" + value);
        });
    }

    public void initialize() {
        this.cache = CacheBuilder.newBuilder().weakKeys().build();
    }

    public void put(Object key, Object value) {
        this.cache.put(key, value);
    }

    public Object get(Object key) {
        return this.cache.getIfPresent(key);
    }

    public <V> V get(Object key, Callable<V> valueLoader) throws ExecutionException {
        return (V)this.cache.get(key, valueLoader);
    }
}

