/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.processors;

import mpicbg.spim.data.generic.AbstractSpimData;
import org.scijava.module.Module;
import org.scijava.module.process.AbstractPostprocessorPlugin;
import org.scijava.module.process.PostprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;

@Plugin(type=PostprocessorPlugin.class)
public class SpimDataPostprocessor
extends AbstractPostprocessorPlugin {
    protected static final Logger logger = LoggerFactory.getLogger(SpimDataPostprocessor.class);
    @Parameter
    SourceAndConverterService bss;

    public void process(Module module) {
        module.getOutputs().forEach((name, object) -> {
            if (object instanceof AbstractSpimData) {
                AbstractSpimData asd = (AbstractSpimData)object;
                logger.debug("SpimData found.");
                this.bss.register(asd);
                module.resolveOutput(name);
                if (module.getInputs().containsKey("datasetname")) {
                    String datasetname = (String)module.getInputs().get("datasetname");
                    this.bss.setSpimDataName(asd, datasetname);
                }
            }
            if (object instanceof AbstractSpimData[]) {
                AbstractSpimData[] asds;
                for (AbstractSpimData asd : asds = (AbstractSpimData[])object) {
                    logger.debug("SpimData found.");
                    this.bss.register(asd);
                    module.resolveOutput(name);
                }
            }
        });
    }
}

