/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.processors;

import bdv.viewer.SourceAndConverter;
import org.scijava.module.Module;
import org.scijava.module.process.AbstractPostprocessorPlugin;
import org.scijava.module.process.PostprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;

@Plugin(type=PostprocessorPlugin.class)
public class SourceAndConverterPostprocessor
extends AbstractPostprocessorPlugin {
    protected static final Logger logger = LoggerFactory.getLogger(SourceAndConverterPostprocessor.class);
    @Parameter
    SourceAndConverterService bss;

    public void process(Module module) {
        module.getOutputs().forEach((name, object) -> {
            if (object instanceof SourceAndConverter) {
                SourceAndConverter sac = (SourceAndConverter)object;
                logger.debug("Source found.");
                logger.debug("Is it registered ? ");
                if (!this.bss.isRegistered(sac)) {
                    logger.debug("No, registers it.");
                    this.bss.register(sac);
                } else {
                    logger.debug("Yes.");
                }
                module.resolveOutput(name);
            }
            if (object instanceof SourceAndConverter[]) {
                SourceAndConverter[] sacs;
                for (SourceAndConverter sac : sacs = (SourceAndConverter[])object) {
                    logger.debug("Source found.");
                    logger.debug("Is it registered ? ");
                    if (!this.bss.isRegistered(sac)) {
                        logger.debug("No.");
                        this.bss.register(sac);
                        continue;
                    }
                    logger.debug("Yes.");
                }
                module.resolveOutput(name);
            }
        });
    }
}

