/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.processors;

import bvv.vistools.BvvHandle;
import org.scijava.module.Module;
import org.scijava.module.process.AbstractPostprocessorPlugin;
import org.scijava.module.process.PostprocessorPlugin;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.bvv.BvvHandleHelper;
import sc.fiji.bdvpg.scijava.services.GuavaWeakCacheService;

@Plugin(type=PostprocessorPlugin.class)
public class BvvHandlePostprocessor
extends AbstractPostprocessorPlugin {
    protected static final Logger logger = LoggerFactory.getLogger(BvvHandlePostprocessor.class);
    @Parameter
    ObjectService os;
    @Parameter
    GuavaWeakCacheService cacheService;

    public void process(Module module) {
        module.getOutputs().forEach((name, object) -> {
            if (object instanceof BvvHandle) {
                BvvHandle bvvh = (BvvHandle)object;
                logger.debug("BvvHandle " + name + " found.");
                this.os.addObject((Object)bvvh);
                BvvHandleHelper.setBvvHandleCloseOperation(bvvh, this.cacheService, this.os, true);
                String windowTitle = BvvHandleHelper.getWindowTitle(bvvh);
                windowTitle = BvvHandleHelper.getUniqueWindowTitle(this.os, windowTitle);
                BvvHandleHelper.setWindowTitle(bvvh, windowTitle);
                module.resolveOutput(name);
            }
        });
    }
}

