/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.converters;

import bdv.viewer.SourceAndConverter;
import java.util.List;
import javax.swing.tree.TreePath;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.Converter;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;

@Plugin(type=Converter.class)
public class StringToSourceAndConverter<I extends String>
extends AbstractConverter<I, SourceAndConverter<?>> {
    @Parameter
    SourceAndConverterService sacsService;

    public <T> T convert(Object src, Class<T> dest) {
        String str = (String)src;
        TreePath tp = this.sacsService.getUI().getTreePathFromString(str);
        if (tp != null) {
            List<SourceAndConverter<?>> potentialSources = this.sacsService.getUI().getSourceAndConvertersFromTreePath(tp);
            if (potentialSources.size() != 1) {
                this.log().warn((Object)"The specified parameters refers no either no source or too many sources");
                return null;
            }
            return (T)potentialSources.get(0);
        }
        return null;
    }

    public Class getOutputType() {
        return SourceAndConverter.class;
    }

    public Class<I> getInputType() {
        return String.class;
    }
}

