/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.viewer;

import bdv.util.BdvHandle;
import bvv.vistools.BvvHandle;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.bvv.BvvHandleHelper;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.viewers.ViewerAdapter;
import sc.fiji.bdvpg.viewers.ViewerTransformSyncStarter;
import sc.fiji.bdvpg.viewers.ViewerTransformSyncStopper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Synchronize Views", description="Synchronizes the view of a set of BDV or BVV windows. A window popup should be closed to stop the synchronization")
public class ViewSynchronizerCommand
implements BdvPlaygroundActionCommand {
    protected static final Logger logger = LoggerFactory.getLogger(ViewSynchronizerCommand.class);
    @Parameter(label="Select Bdv Windows to synchronize", required=false, persist=false)
    BdvHandle[] bdvhs;
    @Parameter(label="Select Bvv Windows to synchronize", required=false, persist=false)
    BvvHandle[] bvvhs;
    @Parameter(label="Synchronize timepoints")
    boolean synchronizetime = true;
    ViewerTransformSyncStarter sync;

    public void run() {
        int i;
        if (this.bdvhs == null) {
            this.bdvhs = new BdvHandle[0];
        }
        if (this.bvvhs == null) {
            this.bvvhs = new BvvHandle[0];
        }
        if (this.bvvhs.length + this.bdvhs.length < 2) {
            logger.error("You should select at least 2 windows!");
            return;
        }
        ViewerAdapter[] handles = new ViewerAdapter[this.bdvhs.length + this.bvvhs.length];
        for (i = 0; i < this.bdvhs.length; ++i) {
            handles[i] = new ViewerAdapter(this.bdvhs[i]);
        }
        for (i = 0; i < this.bvvhs.length; ++i) {
            handles[i + this.bdvhs.length] = new ViewerAdapter(this.bvvhs[i]);
        }
        this.sync = new ViewerTransformSyncStarter(handles, this.synchronizetime);
        if (this.bdvhs.length > 0) {
            this.sync.setHandleInitialReference(new ViewerAdapter(SourceAndConverterServices.getBdvDisplayService().getActiveBdv()));
        }
        this.sync.run();
        JFrame frameStopSync = new JFrame();
        frameStopSync.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                new ViewerTransformSyncStopper(ViewSynchronizerCommand.this.sync.getSynchronizers(), ViewSynchronizerCommand.this.sync.getTimeSynchronizers()).run();
                e.getWindow().dispose();
            }
        });
        frameStopSync.setTitle("Close window to stop synchronization");
        String text = "";
        for (BdvHandle bdvHandle : this.bdvhs) {
            text = text + BdvHandleHelper.getWindowTitle(bdvHandle) + "\n";
        }
        for (BdvHandle bdvHandle : this.bvvhs) {
            text = text + BvvHandleHelper.getWindowTitle((BvvHandle)bdvHandle) + "\n";
        }
        JPanel pane = new JPanel();
        JTextArea textArea = new JTextArea(text);
        textArea.setEditable(false);
        pane.add(textArea);
        frameStopSync.add(pane);
        frameStopSync.setPreferredSize(new Dimension(600, 100));
        frameStopSync.pack();
        frameStopSync.setVisible(true);
    }
}

