/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.spimdata;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.spimdata.importer.SpimDataFromXmlImporter;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>BDVDataset [BigDataServer]", label="Command that opens a BDV dataset from a BigDataServer. Click on Show to display it.")
public class SpimdataBigDataServerImportCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Big Data Server URL")
    String urlserver = "http://tomancak-srv1.mpi-cbg.de:8081";
    @Parameter(label="Dataset Name")
    String datasetname = "Drosophila";

    public void run() {
        try {
            Map<String, String> BDSList = SpimdataBigDataServerImportCommand.getDatasetList(this.urlserver);
            String urlString = BDSList.get(this.datasetname);
            new SpimDataFromXmlImporter(urlString).get();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> getDatasetList(String remoteUrl) throws IOException {
        HashMap<String, String> datasetUrlMap = new HashMap<String, String>();
        URL url = new URL(remoteUrl + "/json/");
        InputStream is = url.openStream();
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
        reader.beginObject();
        while (reader.hasNext()) {
            reader.nextName();
            reader.beginObject();
            String id = null;
            String description = null;
            String thumbnailUrl = null;
            String datasetUrl = null;
            block13: while (reader.hasNext()) {
                String name;
                switch (name = reader.nextName()) {
                    case "id": {
                        id = reader.nextString();
                        continue block13;
                    }
                    case "description": {
                        description = reader.nextString();
                        continue block13;
                    }
                    case "thumbnailUrl": {
                        thumbnailUrl = reader.nextString();
                        continue block13;
                    }
                    case "datasetUrl": {
                        datasetUrl = reader.nextString();
                        continue block13;
                    }
                }
                reader.skipValue();
            }
            if (id != null) {
                datasetUrlMap.put(id, datasetUrl);
            }
            reader.endObject();
        }
        reader.endObject();
        reader.close();
        return datasetUrlMap;
    }
}

