/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.spimdata;

import bdv.viewer.SourceAndConverter;
import java.io.File;
import mpicbg.spim.data.generic.AbstractSpimData;
import org.scijava.Context;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.spimdata.exporter.XmlFromSpimDataExporter;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>Save BDVDataset")
public class SpimDataExporterCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Select source(s)")
    SourceAndConverter<?>[] sacs;
    @Parameter(label="Output File (XML)", style="save")
    public File xmlfilepath;
    @Parameter
    Context context;

    public void run() {
        if (this.sacs == null) {
            System.err.println(" No source selected! ");
        } else {
            if (this.sacs.length > 1) {
                System.out.println("More than one source selected! Getting the first one to catch the linked spimdata object.");
            }
            SourceAndConverter<?> sac = this.sacs[0];
            if (SourceAndConverterServices.getSourceAndConverterService().getMetadata(sac, "SPIMDATA") == null) {
                System.err.println("No BDVDataset associated to the chosen source - Aborting save command");
                return;
            }
            AbstractSpimData asd = ((SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata(sac, (String)"SPIMDATA")).asd;
            asd.setBasePath(new File(this.xmlfilepath.getParent()));
            new XmlFromSpimDataExporter(asd, this.xmlfilepath.getAbsolutePath(), this.context).run();
        }
    }
}

