/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.spimdata;

import com.google.gson.stream.JsonReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.apache.commons.lang.StringUtils;
import org.scijava.command.CommandService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.command.spimdata.SpimdataBigDataServerImportCommand;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>List BigDataServer Datasets")
public class BigDataBrowserPlugInCommand
implements BdvPlaygroundActionCommand {
    private final Map<String, ImageIcon> imageMap = new HashMap<String, ImageIcon>();
    private final Map<String, String> datasetUrlMap = new HashMap<String, String>();
    @Parameter(required=false)
    String serverurl = "http://tomancak-srv1.mpi-cbg.de:8081";
    @Parameter
    CommandService cs;
    @Parameter
    LogService ls;

    public void run() {
        ArrayList<String> nameList = new ArrayList<String>();
        try {
            this.getDatasetList(this.serverurl, nameList);
        }
        catch (IOException e) {
            this.ls.error((Object)("Error connecting to server at " + this.serverurl));
            e.printStackTrace();
            return;
        }
        this.createDatasetListUI(this.serverurl, nameList.toArray());
    }

    private void getDatasetList(String remoteUrl, ArrayList<String> nameList) throws IOException {
        URL url = new URL(remoteUrl + "/json/");
        InputStream is = url.openStream();
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
        reader.beginObject();
        while (reader.hasNext()) {
            reader.nextName();
            reader.beginObject();
            String id = null;
            String description = null;
            String thumbnailUrl = null;
            String datasetUrl = null;
            block13: while (reader.hasNext()) {
                String name;
                switch (name = reader.nextName()) {
                    case "id": {
                        id = reader.nextString();
                        continue block13;
                    }
                    case "description": {
                        description = reader.nextString();
                        continue block13;
                    }
                    case "thumbnailUrl": {
                        thumbnailUrl = reader.nextString();
                        continue block13;
                    }
                    case "datasetUrl": {
                        datasetUrl = reader.nextString();
                        continue block13;
                    }
                }
                reader.skipValue();
            }
            if (id != null) {
                nameList.add(id);
                if (StringUtils.isNotEmpty(thumbnailUrl)) {
                    this.imageMap.put(id, new ImageIcon(new URL(thumbnailUrl)));
                }
                if (datasetUrl != null) {
                    this.datasetUrlMap.put(id, datasetUrl);
                }
            }
            reader.endObject();
        }
        reader.endObject();
        reader.close();
    }

    private void createDatasetListUI(final String remoteUrl, Object[] values) {
        JList<Object> list = new JList<Object>(values);
        list.setCellRenderer(new ThumbnailListRenderer());
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    int index = list.locationToIndex(evt.getPoint());
                    String key = String.valueOf(list.getModel().getElementAt(index));
                    String filename = (String)BigDataBrowserPlugInCommand.this.datasetUrlMap.get(key);
                    String title = new File(filename).getName();
                    BigDataBrowserPlugInCommand.this.cs.run(SpimdataBigDataServerImportCommand.class, true, new Object[]{"urlserver", remoteUrl, "datasetname", title});
                }
            }
        });
        JScrollPane scroll = new JScrollPane(list);
        scroll.setPreferredSize(new Dimension(600, 800));
        JFrame frame = new JFrame();
        frame.setTitle("BigDataServer Browser - " + remoteUrl);
        frame.add(scroll);
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public class ThumbnailListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        Font font = new Font("helvetica", 1, 12);

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            label.setIcon((Icon)BigDataBrowserPlugInCommand.this.imageMap.get(value));
            label.setHorizontalTextPosition(4);
            label.setFont(this.font);
            return label;
        }
    }
}

