/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.source;

import bdv.viewer.SourceAndConverter;
import java.io.File;
import java.util.Arrays;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.sourceandconverter.exporter.XmlHDF5SpimdataExporter;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Export Sources to XML/HDF5 Spimdataset")
public class XmlHDF5ExporterCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Select Source(s)")
    SourceAndConverter<?>[] sacs;
    @Parameter(label="Each source is an independent", choices={"Channel", "Tile"})
    String entitytype;
    @Parameter(label="# of Threads")
    int nthreads = 4;
    @Parameter(label="Timepoint start (0 = first timepoint)")
    int timepointbegin = 0;
    @Parameter(label="Number of timepoint to export (minimum 1)", min="1")
    int numberoftimepointtoexport = 1;
    int timepointend = -1;
    @Parameter(label="Scale factor between pyramid levels")
    int scalefactor = 4;
    @Parameter
    int blocksizex = 64;
    @Parameter
    int blocksizey = 64;
    @Parameter
    int blocksizez = 64;
    @Parameter(label="Dimensions in pixel above which a new resolution level should be created")
    int thresholdformipmap = 512;
    @Parameter(label="Output file (XML)", style="save")
    File xmlfile;

    public void run() {
        this.timepointend = this.timepointbegin + this.numberoftimepointtoexport;
        new XmlHDF5SpimdataExporter(Arrays.asList(this.sacs), this.entitytype, this.nthreads, this.timepointbegin, this.timepointend, this.scalefactor, this.blocksizex, this.blocksizey, this.blocksizez, this.thresholdformipmap, this.xmlfile).run();
    }
}

