/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.scijava.command.source;

import bdv.viewer.SourceAndConverter;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceResampler;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Resample Source Based on Model Source")
public class SourcesResamplerCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Select Source(s)")
    SourceAndConverter<?>[] sacs;
    @Parameter
    SourceAndConverter<?> model;
    @Parameter(label="Re-use MipMaps")
    boolean reusemipmaps;
    @Parameter(label="MipMap level if not re-used (0 = max resolution)")
    int defaultmipmaplevel;
    @Parameter
    boolean interpolate;
    @Parameter
    boolean cache;
    @Parameter(label="Name(s) of the resampled source(s)")
    String name;
    @Parameter(type=ItemIO.OUTPUT)
    SourceAndConverter<?>[] sacs_out;

    public void run() {
        this.sacs_out = new SourceAndConverter[this.sacs.length];
        String[] names = this.name.split(",");
        for (int i = 0; i < this.sacs.length; ++i) {
            SourceAndConverter<?> sac = this.sacs[i];
            this.sacs_out[i] = new SourceResampler(sac, this.model, names[i], this.reusemipmaps, this.cache, this.interpolate, this.defaultmipmaplevel).get();
        }
    }
}

